import Vue from 'vue'
import VueI18n from 'vue-i18n'
import elementEnLocale from 'element-ui/lib/locale/lang/en' // element-ui lang
import elementZhLocale from 'element-ui/lib/locale/lang/zh-CN'// element-ui lang
import elementZhTWLocale from 'element-ui/lib/locale/lang/zh-TW'// element-ui lang
import hotentEnLocale from 'bpm_el_ui/src/locale/lang/en' // bpm_el_ui lang
import hotentZhLocale from 'bpm_el_ui/src/locale/lang/zh-CN'// bpm_el_ui lang
import hotentZhTWLocale from 'bpm_el_ui/src/locale/lang/zh-TW'// bpm_el_ui lang

import enLocale from './lang/en'
import zhLocale from './lang/zh-CN'
import zhTWLocale from './lang/zh-TW'

Vue.use(VueI18n)
const messages = {
  "en-US": {
    ...enLocale,
    ...elementEnLocale,
    ...hotentEnLocale,

  },
  "zh-CN": {
    ...zhLocale,
    ...elementZhLocale,
    ...hotentZhLocale
  },
  "zh-TW": {
    ...zhTWLocale,
    ...elementZhTWLocale,
    ...hotentZhTWLocale
  }
}

const i18n = new VueI18n({
  // set locale
  // options: en | zh 
  locale: localStorage.getItem("lang") || 'zh-CN',
  // set locale messages
  messages
})

export default i18n