package com.artfess.workflow.runtime.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.workflow.runtime.model.BpmTaskTransRecord;

import java.util.List;

/**
 * 任务流转记录接口
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author zhangxianwen
 * @email zhangxw@jee-soft.cn
 * @date 2018年6月28日
 */
public interface BpmTaskTransRecordManager extends BaseManager<BpmTaskTransRecord>{
	
	/**
	 * 根据任务id获取流转任务记录
	 * @param taskId
	 * @return
	 */
	BpmTaskTransRecord getByTaskId(String taskId);
	
	/**
	 * 获取用户的流转记录列表
	 * @param queryFilter
	 * @return
	 */
	PageList<BpmTaskTransRecord> getMyTransRecord(String userId,QueryFilter queryFilter);
	
	/**
	 * 获取流转记录列表
	 * @param queryFilter
	 * @return
	 */
	List<BpmTaskTransRecord> getTransRecordList(QueryFilter queryFilter);
}
