package com.artfess.workflow.bpmModel.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.workflow.bpmModel.model.BpmOftenFlow;
import com.fasterxml.jackson.databind.node.ArrayNode;

import java.util.List;
import java.util.Map;

/**
 *
 * <pre>
 * 描述：通用流程 处理接口
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2019-03-04 15:23:03
 * 版权：广州宏天软件有限公司
 * </pre>
 */
public interface BpmOftenFlowManager extends BaseManager<BpmOftenFlow>{
	/**
	 * 通过用户ID和流程key删除常用流程
	 * <pre>
	 * 不传入defkeys时，会删除该用户下的所有常用流程
	 * </pre>
	 * @param userId
	 * @param defkeys
	 */
    void removeByUserIdAndDefKeys(String userId, List<String> defkeys);

    /**
     * 添加或更新通用的常用流程
     * @param map
     */
    CommonResult<String> saveOrUpdateCommonFlow(Map<String,Object> map) throws Exception;

    /**
     * 保存我的常用流程
     * @param userId
     * @param userName
     * @param list
     */
    void saveMyFlow(String userId, String userName, ArrayNode list);

    /**
     * 通过常用流程ID查询常用流程授权信息
     * @param oftenFlowId
     * @return
     */
    String getBpmOftenFlowUsers(String oftenFlowId);

    /**
     * 获取某用户的常用流程列表
     * @param userId
     * @return
     */
    PageList<BpmOftenFlow> customQuery(String userId);
}
