package com.artfess.uc.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.ElectronicSealDao;
import com.artfess.uc.manager.ElectronicSealManager;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.ElectronicSeal;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.User;
import com.artfess.uc.params.seal.ImportSignatureObject;
import com.artfess.uc.params.seal.UserSignature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：uc_electronic_seal 处理实现类
 * 构建组：x7
 * 作者:lihq
 * 邮箱:lihq@jee-soft.cn
 * 日期:2020-10-19 18:18:31
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("electronicSealManager")
public class ElectronicSealManagerImpl extends BaseManagerImpl<ElectronicSealDao, ElectronicSeal> implements ElectronicSealManager {
	
	@Autowired
	UserManager userManager;
	@Autowired
	PwdStrategyManager pwdStrategyManager;
	
    @Override
    public void setIsUse(String id) {
        super.update(new UpdateWrapper<ElectronicSeal>().set("IS_USE_",1).eq("ID_",id));
    }

	@Override
	@Transactional
	public CommonResult<String> importSignature(ImportSignatureObject signatureData) throws Exception {
		if(BeanUtils.isNotEmpty(signatureData) && BeanUtils.isNotEmpty(signatureData.getSignatureList())){
			List<UserSignature> list = signatureData.getSignatureList();
			List<String> accounts = new ArrayList<String>();
			Map<String,String> signatureMap = new HashMap<String,String>();
			PwdStrategy pwdStrategy = pwdStrategyManager.getDefault();
			for (UserSignature userSignature : list) {
				accounts.add(userSignature.getAccount());
				signatureMap.put(userSignature.getAccount(), userSignature.getFileId());
			}
			//根据账号获取所有相关用户
			QueryFilter filter = QueryFilter.build();
			filter.withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
			filter.addFilter("ACCOUNT_", accounts, QueryOP.IN);
			filter.addFilter("IS_DELE_", "1", QueryOP.NOT_EQUAL);
			PageList<User> page = userManager.query(filter);
			List<User> users = page.getRows();
			if(BeanUtils.isNotEmpty(users) && users.size()>0){
				List<ElectronicSeal> newSeals = new ArrayList<ElectronicSeal>();
				for (User user : users) {
					// 判断当前用户是否存在正在使用的签章
					ElectronicSeal seal = this.getOne(new QueryWrapper<ElectronicSeal>().eq("USER_ID_", user.getId()).eq("IS_USE_", 0));
					if(BeanUtils.isNotEmpty(seal) && signatureData.isRepeatConver()){
						this.setIsUse(seal.getId());
						newSeals.add(this.getNewSeal(user.getId(), signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
					}else if(BeanUtils.isEmpty(seal)){
						newSeals.add(this.getNewSeal(user.getId(), signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
					}
				}
				if(BeanUtils.isNotEmpty(newSeals)){
					boolean isSuccess = this.saveBatch(newSeals);
					if(!isSuccess){
						throw new RuntimeException("签章数据批量插入失败！");
					}
				}
			}
		}
		return new CommonResult<String>(true, "处理成功！");
	}
	
	/**
	 * 初始化一条用户签章记录
	 * @param userId
	 * @param fileId
	 * @param pwd
	 * @return
	 * @throws Exception
	 */
	private ElectronicSeal getNewSeal(String userId,String fileId,String pwd) throws Exception{
		ElectronicSeal newSeal = new ElectronicSeal();
		newSeal.setId(UniqueIdUtil.getSuid());
		newSeal.setIsUse(0);
		newSeal.setUserId(userId);
		newSeal.setFileId(fileId);
		newSeal.setPassword(EncryptUtil.encrypt(pwd)); // 对密码进行加密处理
		return newSeal;
	}
	
}
