package com.artfess.activiti.ext.listener;

import com.artfess.base.util.AppUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.event.TaskCreateEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.service.BpmTaskActionService;

import javax.annotation.Resource;


/**
 * 任务创建的监听器。
 * <pre>
 * 主要处理人员的分配。
 * </pre>
 * @author ray
 *
 */
public class TaskCreateListener extends AbstractTaskListener {


	@Resource
	private BpmTaskActionService bpmTaskActionService;


	/**
	 * serialVersionUID
	 * @since 1.0.0
	 */

	private static final long serialVersionUID = -7836822392037648008L;

	@Override
	public EventType getBeforeTriggerEventType() {
		return EventType.TASK_CREATE_EVENT;
	}

	@Override
	public EventType getAfterTriggerEventType() {
		return EventType.TASK_POST_CREATE_EVENT;
	}

	@Override
	public void beforePluginExecute(BpmDelegateTask delegateTask) throws Exception {
		bpmTaskActionService.create(delegateTask);
	}

	@Override
	public void triggerExecute(BpmDelegateTask delegateTask) {
		TaskCreateEvent startEvent=new TaskCreateEvent(delegateTask);
		//todo 添加license4eip7 包后会导致新增用户任务1的任务新增2条 重复调用了
		//AppUtil.getBean(TaskCreateEventListener.class);
		AppUtil.publishEvent(startEvent);
	}

	@Override
	public void afterPluginExecute(BpmDelegateTask delegateTask) {

	}

	@Override
	protected ScriptType getScriptType() {
		return ScriptType.CREATE;
	}



}
