package com.artfess.portal.persistence.manager;


import com.artfess.portal.params.ActuatorInfo;
import com.artfess.portal.params.TraceInfo;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author wh
 * @Package com.sysplat.sys.modules.monitor.service
 * @date 2020/7/7 15:07
 * @Description:系统监控
 */
public interface ActuatorSystemService {
    /**
    * @Description: 请求跟踪查询 暂时未考虑分页
    * @param
    * @Return:
    * @Author: wh
    * @Date: 2020/7/7 15:12
    */
    List<TraceInfo> getHttpTrace() throws IOException;

    /**
     * @Description: jvm tomcat 运行时间
     * @param type jvm tomcat system
     * @Return:
     * @Author: wh
     * @Date: 2020/7/7 15:12
     */
    List<ActuatorInfo> getMetrics(String type) throws IOException;

    /**
    * @Description: 监控状况监控
    * @param
    * @Return: java.util.Map<java.lang.String,java.lang.String>
    * @Author: wh
    * @Date: 2020/7/8 9:05
    */
    Map<String,String> getHealth() throws IOException;

}
