package com.artfess.portal.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

/**
* 表字段脱敏处理
* <pre>
* 描述：表字段脱敏处理 实体对象
* 构建组：x7
* 作者:heyf
* 邮箱:heyf@jee-soft.cn
* 日期:2020-07-27 16:01:10
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("portal_data_sensitive")
@ApiModel(value = "PortalDataSensitive",description = "表字段脱敏处理")
public class PortalDataSensitive extends BaseModel<PortalDataSensitive>{

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键")
   protected String id;

   @XmlAttribute(name = "dataSourceAlias")
   @TableField("DATA_SOURCE_ALIAS_")
   @ApiModelProperty(value="数据源别名")
   protected String dataSourceAlias;

   @XmlAttribute(name = "tableName")
   @TableField("TABLE_NAME_")
   @ApiModelProperty(value="表名")
   protected String tableName;

   @XmlAttribute(name = "desensitizationRules")
   @TableField("DESENSITIZATION_RULES_")
   @ApiModelProperty(value="脱敏规则")
   protected String desensitizationRules;

   @XmlAttribute(name = "reulesRemark")
   @TableField("REULES_REMARK_")
   @ApiModelProperty(value="脱敏规则说明")
   protected String reulesRemark;

   public void setId(String id) {
       this.id = id;
   }

   /**
    * 返回 主键
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setDataSourceAlias(String dataSourceAlias) {
       this.dataSourceAlias = dataSourceAlias;
   }

   /**
    * 返回 数据源别名
    * @return
    */
   public String getDataSourceAlias() {
       return this.dataSourceAlias;
   }
   public void setTableName(String tableName) {
       this.tableName = tableName.toLowerCase();
   }

   /**
    * 返回 表名
    * @return
    */
   public String getTableName() {
       return this.tableName;
   }
   public void setDesensitizationRules(String desensitizationRules) {
       this.desensitizationRules = desensitizationRules;
   }

   /**
    * 返回 脱敏规则
    * @return
    */
   public String getDesensitizationRules() {
       return this.desensitizationRules;
   }

   public String getReulesRemark() {
       return reulesRemark;
   }

   public void setReulesRemark(String reulesRemark) {
       this.reulesRemark = reulesRemark;
   }

   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id)
       .append("dataSourceAlias", this.dataSourceAlias)
       .append("tableName", this.tableName)
       .append("desensitizationRules", this.desensitizationRules)
       .toString();
   }
}
