package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 年度上报记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-12-07
 */
@Data
@FieldRepeat(fields = {"year"},message = "年份不能重复，请重新选择",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="ExamYearReport对象", description="年度上报记录表")
public class ExamYearReport extends AutoFillModel<ExamYearReport> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择年份",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

}
