package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 考试试题选项
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamQuestionsOption对象", description="考试试题选项")
public class ExamQuestionsOption extends AutoFillModel<ExamQuestionsOption> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试题ID")
    @TableField("question_id_")
    private String questionId;

    @ApiModelProperty(value = "选项编号")
    @TableField("option_key_")
    private String optionKey;

    @ApiModelProperty(value = "选项内容")
    @TableField("option_content_")
    private String optionContent;

    @ApiModelProperty(value = "排序（按照试题排序）")
    @TableField("sn_")
    private Integer sn;

}
