package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 年度组织综合评定表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-08-21
 */
@Data
@TableName("exam_org_evaluation")
@ApiModel(value="ExamOrgEvaluation对象", description="年度组织综合评定表")
public class ExamOrgEvaluation extends AutoFillModel<ExamOrgEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织ID")
    @TableField("org_id_")
    private String orgId;

    @ApiModelProperty(value = "组织名称")
    @TableField("org_name_")
    private String orgName;

    @ApiModelProperty(value = "最后评定时间")
    @TableField("evaluation_time_")
    private LocalDateTime evaluationTime;

    @ApiModelProperty(value = "评价等级")
    @TableField("level_")
    private Integer level;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "应参考人数")
    @TableField("should_count_")
    private Integer shouldCount;

    @ApiModelProperty(value = "实际参与人数")
    @TableField("actual_count_")
    private Integer actualCount;

    @ApiModelProperty(value = "及格率")
    @TableField("pass_rate_")
    private String passRate;

    @ApiModelProperty(value = "优秀率")
    @TableField("excellent_rate_")
    private String excellentRate;

}
