package com.artfess.examine.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.examine.dao.ExamSubjectTypeDao;
import com.artfess.examine.manager.ExamSubjectTypeManager;
import com.artfess.examine.model.ExamSubjectType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 课目分类 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Service
public class ExamSubjectTypeManagerImpl extends BaseManagerImpl<ExamSubjectTypeDao, ExamSubjectType> implements ExamSubjectTypeManager {

    @Override
    public List<ExamSubjectType> getTree(ExamSubjectType entity) {
        QueryWrapper<ExamSubjectType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<ExamSubjectType> sysList = this.baseMapper.selectList(queryWrapper);
        List<ExamSubjectType> tree = BeanUtils.listToTree(sysList);
        return tree;
    }
}
