package com.artfess.examine.manager.impl;

import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamOrgEvaluationManager;
import com.artfess.examine.model.ExamOrgEvaluation;
import com.artfess.examine.vo.OrgVo;
import com.artfess.examine.vo.UserEvaluationVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 年度组织综合评定表 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-08-21
 */
@Service
public class ExamOrgEvaluationManagerImpl extends BaseManagerImpl<ExamOrgEvaluationDao, ExamOrgEvaluation> implements ExamOrgEvaluationManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createOrgEvaluation() {
        //获取所有组织
        List<OrgVo> orgList = this.baseMapper.orgList();
        if (CollectionUtils.isEmpty(orgList)) {
            return;
        }
        orgList = BeanUtils.listToTree(orgList);
        Map<String, OrgVo> orgMap = orgList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        //获取所有组织下 人员 考核信息
        int year = LocalDate.now().getYear();
        List<UserEvaluationVo> userList = this.baseMapper.getOrgUserList(String.valueOf(year));
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        LambdaQueryWrapper<ExamOrgEvaluation> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExamOrgEvaluation::getYear, String.valueOf(year));
        List<ExamOrgEvaluation> list = this.list(queryWrapper);
        Map<String, ExamOrgEvaluation> OrgEvaluationMap = list.stream().collect(Collectors.toMap(item -> item.getOrgId(), item -> item));
        List<ExamOrgEvaluation> orgEvaluations = Lists.newArrayList();
        Map<String, List<UserEvaluationVo>> orgUserListMap = userList.stream().collect(Collectors.groupingBy(user -> user.getOrgId()));
        orgMap.forEach((orgId, org) -> {
            List<UserEvaluationVo> userEvaluationVos = orgUserListMap.get(orgId);
            if (CollectionUtils.isEmpty(userEvaluationVos)) {
                return;
            }
            List<UserEvaluationVo> chargeUser = userEvaluationVos.stream().filter(item -> "2".equals(item.getIsCharge())).collect(Collectors.toList());
            //获取当前负责人
            Integer chargeLevlel = null;
            if (!CollectionUtils.isEmpty(chargeUser)) {
                UserEvaluationVo userEvaluationVo = chargeUser.get(0);
                chargeLevlel = userEvaluationVo.getLevel();
            }
            //本级整体成绩情况
            List<UserEvaluationVo> otherUser = userEvaluationVos.stream().filter(item -> !"2".equals(item.getIsCharge())).collect(Collectors.toList());
            Map<Integer, List<UserEvaluationVo>> levelUserMap = otherUser.stream().filter(item -> null != item.getLevel()).collect(Collectors.groupingBy(user -> user.getLevel()));
            if (CollectionUtils.isEmpty(org.getChildren())) {
                return;
            }
            List<UserEvaluationVo> childrenUsers = Lists.newArrayList();
            org.getChildren().forEach(childrenOrg -> {
                OrgVo orgVo = (OrgVo) childrenOrg;
                List<UserEvaluationVo> childrenUserEvaluationVos = orgUserListMap.get(orgVo.getId());
                if (CollectionUtils.isEmpty(childrenUserEvaluationVos)) {
                    return;
                }
                childrenUsers.addAll(childrenUserEvaluationVos);
            });

            Map<Integer, List<UserEvaluationVo>> childrenLevelUserMap = childrenUsers.stream().filter(item -> null != item.getLevel()).collect(Collectors.groupingBy(user -> user.getLevel()));
            ExamOrgEvaluation examOrgEvaluation = new ExamOrgEvaluation();
            if (null != OrgEvaluationMap.get(orgId)) {
                examOrgEvaluation = OrgEvaluationMap.get(orgId);
            }
            examOrgEvaluation.setYear(String.valueOf(year));
            examOrgEvaluation.setOrgId(orgId);
            examOrgEvaluation.setOrgName(org.getName());
            examOrgEvaluation.setEvaluationTime(LocalDateTime.now());
            examOrgEvaluation.setShouldCount(userEvaluationVos.size());
            //未参与考试的人数
            long count = userEvaluationVos.stream().filter(item -> null == item.getLevel()).count();
            examOrgEvaluation.setActualCount(userEvaluationVos.size() - Integer.parseInt(String.valueOf(count)));
            Integer level = getOrgEvaluationLevel(chargeLevlel, examOrgEvaluation, otherUser, levelUserMap, childrenUsers, childrenLevelUserMap);
            examOrgEvaluation.setLevel(level);
            orgEvaluations.add(examOrgEvaluation);
        });
        this.saveOrUpdateBatch(orgEvaluations);
    }

    /**
     * TODO 计算及格率 配置定时任务
     *
     * @param chargeLevlel
     * @param otherUser
     * @param levelUserMap
     * @param childrenUsers
     * @param childrenLevelUserMap
     * @return
     */
    private Integer getOrgEvaluationLevel(Integer chargeLevlel,
                                          ExamOrgEvaluation examOrgEvaluation,
                                          List<UserEvaluationVo> otherUser,
                                          Map<Integer, List<UserEvaluationVo>> levelUserMap,
                                          List<UserEvaluationVo> childrenUsers,
                                          Map<Integer, List<UserEvaluationVo>> childrenLevelUserMap) {
        if (null == chargeLevlel) {
            return null;
        }
        Integer currentLhCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.LH.getType())) {
            currentLhCount = levelUserMap.get(ScoreLevelEnum.LH.getType()).size();
        }
        Integer currentGoodCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.GOOD.getType())) {
            currentGoodCount = levelUserMap.get(ScoreLevelEnum.GOOD.getType()).size();
        }

        Integer currentJgCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.JG.getType())) {
            currentJgCount = levelUserMap.get(ScoreLevelEnum.JG.getType()).size();
        }

        Integer childrenLhCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.LH.getType())) {
            childrenLhCount = childrenLevelUserMap.get(ScoreLevelEnum.LH.getType()).size();
        }
        Integer childrenGoodCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.GOOD.getType())) {
            childrenGoodCount = childrenLevelUserMap.get(ScoreLevelEnum.GOOD.getType()).size();
        }
        Integer childrenJgCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.JG.getType())) {
            childrenJgCount = childrenLevelUserMap.get(ScoreLevelEnum.JG.getType()).size();
        }

        Integer level = null;
        if (chargeLevlel.equals(ScoreLevelEnum.GOOD.getType())) {
            if (currentLhCount + currentGoodCount == otherUser.size() && childrenLhCount + childrenGoodCount == childrenUsers.size()
                    || (currentGoodCount == otherUser.size() && childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size())) {
                level = ScoreLevelEnum.GOOD.getType();
            }
        }
        if (chargeLevlel <=ScoreLevelEnum.LH.getType()) {
            //及格--1.成绩为良好以上，其他两项成绩至少一项为及格以上。。
            if (currentLhCount + currentGoodCount + currentJgCount == otherUser.size()
                    || childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
                level = ScoreLevelEnum.JG.getType();
            }
            //良好--本级主管年度,成绩为良好以上，其他两项成绩一项为良好以上，一项为及格以上。、
            if (currentLhCount + currentGoodCount == otherUser.size()
                    || childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
                level = ScoreLevelEnum.LH.getType();
            }
        }
        if (chargeLevlel <= ScoreLevelEnum.JG.getType()) {
            //及格 --2.各项成绩均为及格以上;或者本级主管年度
            if (currentLhCount + currentGoodCount + currentJgCount == otherUser.size() && childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
                level = ScoreLevelEnum.GOOD.getType();
            }
        }
        if(null == level) {
            level = ScoreLevelEnum.BJG.getType();
        }
        Integer goodCount = currentGoodCount + childrenGoodCount;
        String excellentRate = new BigDecimal(goodCount).divide(new BigDecimal(examOrgEvaluation.getShouldCount()), 2, BigDecimal.ROUND_HALF_UP)
                .multiply(new BigDecimal(100)) + "%";
        examOrgEvaluation.setExcellentRate(excellentRate);

        Integer jgCount = currentLhCount + currentGoodCount + currentJgCount + childrenLhCount + childrenGoodCount + childrenJgCount;
        String passRate = new BigDecimal(jgCount).divide(new BigDecimal(examOrgEvaluation.getShouldCount()), 2, BigDecimal.ROUND_HALF_UP)
                .multiply(new BigDecimal(100)) + "%";
        examOrgEvaluation.setPassRate(passRate);
        return level;
    }
}
