package com.artfess.examine.manager.impl;

import com.artfess.base.enums.AccessControlTypeEnum;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.examine.dao.ExamMaterialTypeAuthDao;
import com.artfess.examine.manager.ExamMaterialTypeAuthManager;
import com.artfess.examine.model.ExamMaterialAuth;
import com.artfess.examine.vo.ExamMaterialTypeAuthVo;
import com.artfess.examine.vo.ExamMaterialVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 资料分类授权表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Service
public class ExamMaterialTypeAuthManagerImpl extends BaseManagerImpl<ExamMaterialTypeAuthDao, ExamMaterialAuth> implements ExamMaterialTypeAuthManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveAuth(ExamMaterialVo auth) {

        if(StringUtils.isEmpty(auth.getMaterialId())){
            throw new RequiredException("资料信息id不能为空");
        }

        QueryWrapper<ExamMaterialAuth> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("material_id_", auth.getMaterialId());
        this.baseMapper.delete(queryWrapper);

        if(!AccessControlTypeEnum.ALL.getType().equals(auth.getAccessControlType())){
            Assert.notEmpty(auth.getAccessControlList(), "请选择权限受控对象");
            auth.getAccessControlList().forEach(control -> {
                ExamMaterialAuth materialTypeAuth = new ExamMaterialAuth();
                materialTypeAuth.setMaterialId(auth.getMaterialId());
                materialTypeAuth.setAccessControlType(auth.getAccessControlType());
                materialTypeAuth.setAccessControlId(control.getAccessControlId());
                materialTypeAuth.setAccessControlName(control.getAccessControlName());
                materialTypeAuth.setAuthType(auth.getAuthType());
                this.baseMapper.insert(materialTypeAuth);
            });
        }else {
            ExamMaterialAuth materialAuth = new ExamMaterialAuth();
            materialAuth.setMaterialId(auth.getMaterialId());
            materialAuth.setAccessControlType(auth.getAccessControlType());
            materialAuth.setAuthType(auth.getAuthType());
            this.baseMapper.insert(materialAuth);

        }




    }

    @Override
    public ExamMaterialVo findByTypeId(String typeId) {
        QueryWrapper<ExamMaterialAuth> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("material_id_", typeId);
        List<ExamMaterialAuth> auths = this.baseMapper.selectList(queryWrapper);
        if(CollectionUtils.isEmpty(auths)){
            return new ExamMaterialVo();
        }
        ExamMaterialAuth bizFileTemplateAuth = auths.get(0);
        ExamMaterialVo typeVo = new ExamMaterialVo();
        BeanUtils.copyProperties(bizFileTemplateAuth, typeVo);
        List<ExamMaterialTypeAuthVo> list = DmpBeanUtil.copyList(auths, ExamMaterialTypeAuthVo.class);
        typeVo.setAccessControlList(list);
        return typeVo;
    }
}
