package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.model.ExamImitateRecord;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.vo.ExamReqVo;
import com.artfess.examine.vo.MyExamInfoVo;
import com.artfess.examine.vo.QuestionsInfoVo;
import com.artfess.examine.vo.SubmitAnswerReqVo;

import java.util.List;

/**
 * 考生模拟考试记录（人员考试成绩） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamImitateRecordManager extends BaseManager<ExamImitateRecord> {

    void startPaper(String id);

    void createImitate(ExamPaperBase t);

    MyExamInfoVo getUserRecord(String id);

    MyExamInfoVo startExam(ExamReqVo reqVo);

    void submitAnswer(SubmitAnswerReqVo vo);

    PageList<ExamImitateRecord> trainingPaperQuery(QueryFilter<ExamImitateRecord> queryFilter);

    List<QuestionsInfoVo> errorQuestionsList(String id);
}
