package com.artfess.data.vo;

import com.artfess.data.model.*;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetailTy;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@lombok.Data
@ApiModel(value = "ExamUserEvaluationVo对象", description = "年度考核考生(体育成绩课目)明细记录表")
public class ExamUserEvaluationVo {

    @ApiModelProperty(value = "年度")
    private String year;

    @ApiModelProperty(value = "年度考生综合评定表")
    private ExamUserEvaluation examUserEvaluation;
//
//    @ApiModelProperty(value = "年度考核成绩表")
//    private List<ExamUserEvaluationDetail> examUserEvaluationDetailList;

    @ApiModelProperty(value = "年度考核考生---专 业 共 同")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> professionalCommonDetail;

    @ApiModelProperty(value = "年度考核考生---专 业 X X")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> professionalXXDetail;

    @ApiModelProperty(value = "年度考核考生---X X 共 同")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> XXCommonDetail;

    @ApiModelProperty(value = "年度考核考生---X X 体 育")
    @TableField(exist = false)
    private List<ExamUserEvaluationDetailTy> XXSportsDetail;

    @ApiModelProperty(value = "年度成绩统计")
    private List<BizSubjectScoreCount> subjectScoreCounts;

    @ApiModelProperty(value = "XXX资质及成果表（按年明细记录表）")
    private List<BizUserAchieveDetail> bizUserAchieveDetailList;

    @ApiModelProperty(value = "xxx成绩与奖惩表（按年成绩明细记录表）")
    private List<BizUserGrade> bizUserGradeList;

    @ApiModelProperty(value = "xxx经历表（按年明细记录表）")
    private List<BizUserThroughDetail> bizUserThroughDetailList;

}
