package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * xxx经历表（按年明细记录表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value="BizUserThroughDetail对象", description="xxx经历表（按年明细记录表）")
public class BizUserThroughDetail extends AutoFillModel<BizUserThroughDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "填档年份（格式：2024）")
    @TableField("td_year_")
    private Integer tdYear;

    @ApiModelProperty(value = "经历分类（1xxx经历  2xxx经历）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "参加xxx")
    @TableField("field1_")
    private String field1;

    @ApiModelProperty(value = "参加xxx活动")
    @TableField("field2_")
    private String field2;

    @ApiModelProperty(value = "参加院校教育培训")
    @TableField("field3_")
    private String field3;

    @ApiModelProperty(value = "参加xxx竞赛")
    @TableField("field4_")
    private String field4;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

}
