package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * xxx资质及成果表（按年汇总统计表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@ApiModel(value="BizUserAchieveStatic对象", description="xxx资质及成果表（按年汇总统计表）")
public class BizUserAchieveStatic extends BaseModel<BizUserAchieveStatic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "专业等级评定")
    @TableField("profession_assess_")
    private String professionAssess;

    @ApiModelProperty(value = "教学能力评定")
    @TableField("teach_assess_")
    private String teachAssess;

    @ApiModelProperty(value = "职业技能鉴定")
    @TableField("vocation_assess_")
    private String vocationAssess;

    @ApiModelProperty(value = "执业资格认证")
    @TableField("practice_assess_")
    private String practiceAssess;

    @ApiModelProperty(value = "xxx成果")
    @TableField("archivement_")
    private String archivement;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserArchiveId() {
        return userArchiveId;
    }

    public void setUserArchiveId(String userArchiveId) {
        this.userArchiveId = userArchiveId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIdentiCard() {
        return identiCard;
    }

    public void setIdentiCard(String identiCard) {
        this.identiCard = identiCard;
    }

    public String getProfessionAssess() {
        return professionAssess;
    }

    public void setProfessionAssess(String professionAssess) {
        this.professionAssess = professionAssess;
    }

    public String getTeachAssess() {
        return teachAssess;
    }

    public void setTeachAssess(String teachAssess) {
        this.teachAssess = teachAssess;
    }

    public String getVocationAssess() {
        return vocationAssess;
    }

    public void setVocationAssess(String vocationAssess) {
        this.vocationAssess = vocationAssess;
    }

    public String getPracticeAssess() {
        return practiceAssess;
    }

    public void setPracticeAssess(String practiceAssess) {
        this.practiceAssess = practiceAssess;
    }

    public String getArchivement() {
        return archivement;
    }

    public void setArchivement(String archivement) {
        this.archivement = archivement;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserAchieveStatic{" +
            "id=" + id +
            ", userArchiveId=" + userArchiveId +
            ", userName=" + userName +
            ", identiCard=" + identiCard +
            ", professionAssess=" + professionAssess +
            ", teachAssess=" + teachAssess +
            ", vocationAssess=" + vocationAssess +
            ", practiceAssess=" + practiceAssess +
            ", archivement=" + archivement +
        "}";
    }
}
