package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 课目考核数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizSubExamData对象", description="课目考核数据")
public class BizSubExamData extends AutoFillModel<BizSubExamData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "年", column = "G")
    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @Excel(name = "用户姓名", column = "A")
    @ApiModelProperty(value = "用户姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "用户id")
    @TableField("user_id_")
    private String userId;

    @Excel(name = "岗位", column = "B")
    @ApiModelProperty(value = "岗位")
    @TableField("post_")
    private String post;

    @ApiModelProperty(value = "岗位ID")
    @TableField("post_id_")
    private String postId;

    @Excel(name = "归属单位", column = "C")
    @ApiModelProperty(value = "归属单位")
    @TableField("company_name_")
    private String companyName;

    @ApiModelProperty(value = "归属单位id")
    @TableField("company_id_")
    private String companyId;

    @Excel(name = "考核课目", column = "D")
    @ApiModelProperty(value = "考核课目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "考核课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "评定等级成绩", column = "E")
    @ApiModelProperty(value = "评定等级成绩")
    @TableField("rate_level_")
    private String rateLevel;

    @Excel(name = "考核成绩", column = "F")
    @ApiModelProperty(value = "考核成绩")
    @TableField("score_")
    private BigDecimal score;

    @Excel(name = "备注", column = "G")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
