package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 教练员任教课目表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@ApiModel(value="BizCouchTeach对象", description="教练员任教课目表")
public class BizCouchTeach extends BaseModel<BizCouchTeach> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableField("id_")
    private String id;

    @ApiModelProperty(value = "教练员id")
    @TableField("couch_id_")
    private String couchId;

    @ApiModelProperty(value = "任教课目id")
    @TableField("subject_id_")
    private String subjectId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCouchId() {
        return couchId;
    }

    public void setCouchId(String couchId) {
        this.couchId = couchId;
    }

    public String getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }


    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizCouchTeach{" +
            "id=" + id +
            ", couchId=" + couchId +
            ", subjectId=" + subjectId +
        "}";
    }
}
