package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizTeachDataDao;
import com.artfess.data.manager.BizSubjectResourcesManager;
import com.artfess.data.manager.BizTeachDataManager;
import com.artfess.data.model.BizSubjectResources;
import com.artfess.data.model.BizTeachData;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 任教课目准备数据 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-09-02
 */
@Service
public class BizTeachDataManagerImpl extends BaseManagerImpl<BizTeachDataDao, BizTeachData> implements BizTeachDataManager {

    @Autowired
    private BizSubjectResourcesManager subjectResourcesManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(BizTeachData t) {
        boolean save = this.save(t);
        if (save) {
            processInfo(t);
            return save;
        }
        return false;
    }

    private void processInfo(BizTeachData t) {
        LambdaQueryWrapper<BizSubjectResources> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(BizSubjectResources::getTeachId, t.getId());
        subjectResourcesManager.remove(lambdaQueryWrapper);


        t.getSubjectResourcesList().forEach(bizSubjectResources -> {
            bizSubjectResources.setTeachId(t.getId());
        });
        subjectResourcesManager.saveBatch(t.getSubjectResourcesList());
    }

    @Override
    public BizTeachData findById(String id) {
        BizTeachData bizTeachData = this.get(id);
        if (null == bizTeachData) {
            return new BizTeachData();
        }
        LambdaQueryWrapper<BizSubjectResources> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(BizSubjectResources::getTeachId, id);
        List<BizSubjectResources> list = subjectResourcesManager.list(lambdaQueryWrapper);
        bizTeachData.setSubjectResourcesList(list);

        return bizTeachData;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(BizTeachData t) {
        boolean save = this.updateById(t);
        if (save) {
            processInfo(t);
            return save;
        }
        return false;
    }
}
