package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.manager.BizRegulatoryFileManager;
import com.artfess.data.model.BizRegulatoryFile;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 法规文件 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Slf4j
@RestController
@Api(tags = "训练数据-法规文件")
@RequestMapping("/biz/regulatory/file/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizRegulatoryFileController extends BaseController<BizRegulatoryFileManager, BizRegulatoryFile> {

    @ApiOperation(value = "导入")
    @PostMapping("/importExcel")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file, @RequestParam(value = "knowledgeTypeId", required = false) String knowledgeTypeId) {
        try {
            Assert.hasText(knowledgeTypeId, "请选择分类");
            ExcelUtils<BizRegulatoryFile> excelUtil = new ExcelUtils<>(BizRegulatoryFile.class);
            List<BizRegulatoryFile> list = excelUtil.importExcel(null, file.getInputStream());
            list.forEach(data -> {
                data.setKnowledgeTypeId(knowledgeTypeId);
            });
            baseService.saveBatch(list);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("导入失败," + e.getMessage());
        }
    }

    @ApiOperation(value = "导出")
    @PostMapping("/export")
    public void export(HttpServletResponse response, HttpServletRequest request,
                       @ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizRegulatoryFile> queryFilter) throws Exception {
        PageList<BizRegulatoryFile> page = baseService.query(queryFilter);
        ExcelUtils<BizRegulatoryFile> util = new ExcelUtils<BizRegulatoryFile>(BizRegulatoryFile.class);
        util.exportExcel(response, request, page.getRows(), "法规文件数据");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/训练知识数据/法规文件.xlsx");
            FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "法规文件数据模板.xlsx");
        } catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("你所下载的资源不存在");
        }
    }
}
