package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.data.manager.BizDataExportManager;
import com.artfess.data.model.BizDataExport;
import com.artfess.data.vo.SysLogsVo;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 基站数据导出 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Slf4j
@RestController
@Api(tags = "训练数据-基站数据导出")
@RequestMapping("/biz/data/export/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizDataExportController extends BaseController<BizDataExportManager, BizDataExport> {

    @ApiOperation(value = "导出")
    @PostMapping("/export")
    public void export(HttpServletResponse response, HttpServletRequest request,
                       @ApiParam(name="queryFilter", value="分页查询信息") @RequestBody BizDataExport dataExport) throws Exception {
        List<SysLogsVo> dataList = baseService.getSysLogs(dataExport);
        ExcelUtils<SysLogsVo> util = new ExcelUtils<SysLogsVo>(SysLogsVo.class);
        util.exportExcel(response, request, dataList, "基站数据操作记录");
        dataExport.setStatus("1");
        this.baseService.save(dataExport);
    }

}
