package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 资料文件管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamFile对象", description="资料文件管理")
public class ExamFile extends AutoFillModel<ExamFile> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资料id")
    @TableField("material_id_")
    private String materialId;

    @ApiModelProperty(value = "资料格式")
    @TableField("file_ext_")
    private String fileExt;

    @ApiModelProperty(value = "文件名称")
    @TableField("file_name_")
    private String fileName;

    @ApiModelProperty(value = "资料类型【字典】 （1图片、2文字、3音频、4视频、5压缩包等）")
    @TableField("file_type_")
    private String fileType;

    @ApiModelProperty(value = "文件地址")
    @TableField("file_url_")
    private String fileUrl;

    @ApiModelProperty(value = "文件大小(字节数)")
    @TableField("file_sizes")
    private BigDecimal fileSizes;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
