package com.artfess.examine.manager.impl;

import com.artfess.base.enums.PaperWayTypeEnum;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.examine.dao.ExamPaperTaskDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.manager.ExamPaperTaskManager;
import com.artfess.examine.manager.ExamTaskManager;
import com.artfess.examine.manager.ExamUserRecordDetailManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamPaperTask;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamTask;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.model.ExamUserRecordDetail;
import com.artfess.examine.vo.UserInfoVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 考试任务表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Service
public class ExamPaperTaskManagerImpl extends BaseManagerImpl<ExamPaperTaskDao, ExamPaperTask> implements ExamPaperTaskManager {

    @Autowired
    private ExamPaperBaseManager paperBaseManager;

    @Resource
    private ExamSubjectInfoDao subjectInfoDao;

    @Autowired
    private ExamTaskManager taskManager;

    @Autowired
    private ExamUserRecordDetailManager userRecordDetailManager;

    @Autowired
    private ExamUserRecordManager userRecordManager;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public String createTask(ExamPaperTask t) {

        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String updateTask(ExamPaperTask t) {
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void startTask(String id) {
        Assert.hasText(id, "请选择要发布的任务");
        ExamPaperTask examPaperTask = this.baseMapper.selectById(id);
        Assert.notNull(examPaperTask, "发布的任务不存在");
        Assert.hasText(examPaperTask.getPaperId(), "该任务只有关联试卷后才能进行发布");
        ExamPaperBase examPaperBase = paperBaseManager.getBaseMapper().selectById(examPaperTask.getPaperId());
        Assert.notNull(examPaperBase, "关联的试卷不存在");
        if("1".equals(examPaperTask.getStatus())) {
            throw new RuntimeException("任务已发布，不能再次发布");
        }

        //获取试卷课目 给对应的考生添加任务
        ExamSubjectInfo examSubjectInfo = subjectInfoDao.selectById(examPaperBase.getSubjectId());
        Assert.notNull(examSubjectInfo, "关联的考试课目不存在");
        List<UserInfoVo> userInfoVoList = null;
//                this.baseMapper.getUserIds(examSubjectInfo.getPositionId());
        List<ExamTask> taskList = Lists.newArrayList();
        userInfoVoList.forEach(user -> {
            ExamTask task = new ExamTask();
            task.setReceiveUser(user.getUserId());
            task.setTaskId(id);
            taskList.add(task);
        });
        taskManager.saveBatch(taskList);
        //计划状态修改
        examPaperTask.setStatus("1");
        this.baseMapper.updateById(examPaperTask);
        //发布成功生成试卷
        processPaperSettingInfo(userInfoVoList, examPaperBase, id);
    }

    private void processPaperSettingInfo(List<UserInfoVo> userInfoVoList, ExamPaperBase examPaperBase, String taskId) {
        //随机出卷每个考生试卷都是根据规则随机生成
        if(PaperWayTypeEnum.sjcj.getType().equals(examPaperBase.getWayType())) {
            userInfoVoList.forEach(userVo -> {
                List<ExamQuestionsInfo> examQuestionsInfos = paperBaseManager.processQuestionList(examPaperBase);
                createUserRecord(userVo, examQuestionsInfos, examPaperBase, taskId);
            });

        } else {
            List<ExamQuestionsInfo> examQuestionsInfos = paperBaseManager.processQuestionList(examPaperBase);

            userInfoVoList.forEach(userVo -> {
                createUserRecord(userVo, examQuestionsInfos, examPaperBase, taskId);

            });
        }

    }

    private void createUserRecord(UserInfoVo userVo, List<ExamQuestionsInfo> examQuestionsInfos, ExamPaperBase examPaperBase, String taskId) {
        List<ExamUserRecordDetail> records = Lists.newArrayList();
        ExamUserRecord examUserRecord = new ExamUserRecord();
        examUserRecord.setPaperId(taskId);
        examUserRecord.setUserId(userVo.getUserId());
        examUserRecord.setUserName(userVo.getUserName());
        examUserRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
        userRecordManager.save(examUserRecord);
        //保存考生试卷信息
        //保存考生题目信息
        examQuestionsInfos.forEach(question->{
            ExamUserRecordDetail userRecordDetail = new ExamUserRecordDetail();
            userRecordDetail.setRecordId(examUserRecord.getId());
            userRecordDetail.setQuestionId(question.getId());
            userRecordDetail.setQuestionType(question.getType());
            userRecordDetail.setRightKey(question.getRightOption());
            userRecordDetail.setScore(question.getScore());
            records.add(userRecordDetail);
        });

        if(!CollectionUtils.isEmpty(records)) {
            userRecordDetailManager.saveBatch(records);
        }
    }
}
