package com.artfess.data.vo;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.time.LocalDateTime;

/**
 * 系统操作日志
 * <pre>
 * 描述：系统操作日志 实体对象
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-08-31 10:59:25
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@Data
@ApiModel(value = "系统操作日志VO", description = "系统操作日志")
public class SysLogsVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name = "id", notes = "主键")
    protected String id;

    @Excel(name = "操作名称", column = "A")
    @ApiModelProperty(value = "操作名称")
    protected String opeName;

    @ApiModelProperty(value = "执行时间")
    protected LocalDateTime executionTime;

    @Excel(name = "执行人", column = "C")
    @ApiModelProperty(value = "执行人")
    protected String executor;

    @Excel(name = "请求url地址", column = "D")
    @ApiModelProperty(value = "请求url地址")
    protected String reqUrl;

    @Excel(name = "操作内容", column = "E")
    @ApiModelProperty(value = "操作内容")
    protected String opeContent;

    @Excel(name = "requestMethod", column = "F")
    @ApiModelProperty(value = "http请求方法（get、post、delete、put）")
    protected String requestMethod;

}
