package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 人员考勤数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizUserCheck对象", description="人员考勤数据")
public class BizUserCheck extends BaseModel<BizUserCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择训练计划", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "训练id")
    @TableField("plan_id_")
    private String planId;

    @Excel(name = "年度", column = "A")
    @ApiModelProperty(value = "年度")
    @TableField(exist = false)
    private String year;

    @Excel(name = "月份", column = "B")
    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private Integer month;

    @Excel(name = "周序号", column = "C")
    @ApiModelProperty(value = "周序号【字典】（1：第一周、2：第二周、3：第三周、4：第四周）")
    @TableField("week_")
    private String week;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "D")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "课目", column = "E")
    @ApiModelProperty(value = "课目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "考勤日期", column = "F")
    @ApiModelProperty(value = "考勤日期")
    @TableField("check_date_")
    private String checkDate;

    @ApiModelProperty(value = "考生id")
    @TableField("user_id_")
    private String userId;

    @Excel(name = "考生姓名", column = "G")
    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "训练文件（图片或视屏，文件以json格式存储）")
    @TableField("train_file_")
    private String trainFile;

    @ApiModelProperty(value = "是否考勤，1已考勤，0未考勤")
    @TableField(value = "status_")
    private String status = "0";

    @Excel(name = "备注", column = "H")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

}
