/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WordUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.file.util.AppFileUtil;
import com.artfess.poi.util.FileDownloadUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamUserEvaluationDetailManagerImpl
extends BaseManagerImpl<ExamUserEvaluationDetailDao, ExamUserEvaluationDetail>
implements ExamUserEvaluationDetailManager {
    @Override
    public PageList<ExamUserEvaluationDetail> findByPage(QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamUserEvaluationDetail> result = ((ExamUserEvaluationDetailDao)this.baseMapper).findByPage((IPage<ExamUserEvaluationDetail>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluationDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void personArchivesExport(QueryFilter<ExamUserEvaluationDetail> queryFilter, HttpServletResponse response) {
        PageList<ExamUserEvaluationDetail> result = this.findByPage(queryFilter);
        String fileId = UniqueIdUtil.getSuid();
        String path = AppFileUtil.createFileMkdirs((String)("ftl" + File.separator + fileId));
        Map<String, List<ExamUserEvaluationDetail>> map = result.getRows().stream().filter(item -> !StringUtil.isEmpty((String)item.getUserId())).collect(Collectors.groupingBy(ExamUserEvaluationDetail::getUserId));
        map.forEach((userId, list) -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            JSONObject dataMap = new JSONObject();
            dataMap.put("year", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getYear());
            dataMap.put("userName", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getUserName());
            String examTime = DateFormatUtil.formaDateTime((LocalDateTime)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getCreateTime());
            dataMap.put("examTime", (Object)examTime);
            dataMap.put("mobile", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getMobile());
            dataMap.put("sex", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getSex());
            dataMap.put("idCard", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getIdCard());
            dataMap.put("birthday", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getBirthday());
            dataMap.put("entryDate", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getEntryDate());
            dataMap.put("education", (Object)((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getEducation());
            list.forEach(detail -> detail.setLevelDesc(ScoreLevelEnum.getDesc((Integer)detail.getLevel())));
            dataMap.put("list", list);
            String fileOnlyName = ((ExamUserEvaluationDetail)((Object)((Object)list.get(0)))).getUserName() + "\u4e2a\u4eba\u6863\u6848.doc";
            String ftlPath = AppFileUtil.createFilePath((String)("ftl" + File.separator + fileId), (String)fileOnlyName);
            WordUtil.createWord((HttpServletResponse)response, (Map)dataMap, (String)"\u4e2a\u4eba\u6863\u6848.ftl", (String)ftlPath, (String)fileOnlyName);
        });
        ZipUtil.zip((String)path, (Boolean)true);
        try {
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (File)new File(path + ".zip"), (String)"\u4e2a\u4eba\u6863\u6848\u53f0\u5e10.zip");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageList<UserExamVo> userStudyAnalyse(QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<UserExamVo> result = ((ExamUserEvaluationDetailDao)this.baseMapper).userStudyAnalyse((IPage<ExamUserEvaluationDetail>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluationDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public String getSubjectNames(String positionId, String year, String userId) {
        return ((ExamUserEvaluationDetailDao)this.baseMapper).getSubjectNames(positionId, year, userId);
    }
}

