/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.manager.ExamYearAssessmentSubManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamYearAssessmentSub;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u8003\u6838\u8bfe\u76ee"})
@RequestMapping(value={"/exam/year/assessmentSub/"})
@ApiGroup(group={"group_biz"})
public class ExamYearAssessmentSubController
extends BaseController<ExamYearAssessmentSubManager, ExamYearAssessmentSub> {
    private static final Logger log = LoggerFactory.getLogger(ExamYearAssessmentSubController.class);
    @Resource
    private ExamUserEvaluationManager userEvaluationManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamYearAssessmentSub t) {
        log.info("\u8003\u6838\u8bfe\u76ee\u4fdd\u5b58\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)t)));
        boolean result = ((ExamYearAssessmentSubManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamYearAssessmentSub t) {
        log.info("\u4fee\u6539\u8003\u6838\u8bfe\u76ee\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)t)));
        boolean result = ((ExamYearAssessmentSubManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public ExamYearAssessmentSub getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamYearAssessmentSubManager)this.baseService).findById(id);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id_", Arrays.asList(ids));
        List examYearAssessmentSubs = ((ExamYearAssessmentSubManager)this.baseService).getBaseMapper().selectList((Wrapper)queryWrapper);
        examYearAssessmentSubs.forEach(sub -> {
            boolean result = this.userEvaluationManager.delPositionSubject(sub.getSubjectIds(), sub.getPositionId(), sub.getYear());
            if (!result) {
                throw new BaseException("\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
            }
        });
        return new CommonResult();
    }

    @PostMapping(value={"/deleteSub"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u8003\u6838\u8bfe\u76ee")
    public CommonResult<String> deleteSub(@ApiParam(name="sub", value="\u5b9e\u4f53\u96c6\u5408") @RequestBody ExamYearAssessmentSub sub) {
        boolean result = this.userEvaluationManager.delPositionSubject(sub.getSubjectIds(), sub.getPositionId(), sub.getYear());
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/findByPositionId/{positionId}"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u83b7\u53d6\u5f53\u5e74\u8003\u6838\u8bfe\u76ee")
    public List<ExamSubjectInfo> findByPositionId(@ApiParam(name="positionId", value="\u5c97\u4f4did") @PathVariable String positionId) {
        return ((ExamYearAssessmentSubManager)this.baseService).findByPositionId(positionId);
    }

    @PostMapping(value={"/findByPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e74\u5ea6\u8003\u6838\u8bd5\u5377\u9009\u62e9\u8bfe\u76ee\u5206\u9875\u63a5\u53e3")
    public PageList<ExamSubjectInfo> findByPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamSubjectInfo> queryFilter) {
        return ((ExamYearAssessmentSubManager)this.baseService).findByPage(queryFilter);
    }
}

