/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.data.dao.BizTrainEquipmentDataDao;
import com.artfess.data.manager.BizTrainEquipmentDataManager;
import com.artfess.data.model.BizTrainEquipmentData;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizTrainEquipmentDataManagerImpl
extends BaseManagerImpl<BizTrainEquipmentDataDao, BizTrainEquipmentData>
implements BizTrainEquipmentDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Override
    public void saveList(List<BizTrainEquipmentData> list) {
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText((String)data.getName(), (String)"\u8bf7\u586b\u5199\u5668\u6750\u540d\u79f0");
            if (null != DictionaryUtils.getDictInfo((String)"qclx", (String)data.getType())) {
                String type = DictionaryUtils.getDictInfo((String)"qclx", (String)data.getType()).getValue();
                data.setType(type);
            }
            if (null != DictionaryUtils.getDictInfo((String)"jldw", (String)data.getType())) {
                String unit = DictionaryUtils.getDictInfo((String)"jldw", (String)data.getType()).getValue();
                data.setUnit(unit);
            }
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(((OrgVo)((Object)((Object)orgMap.get(data.getOrgName())))).getId());
            }
        });
        this.saveBatch(list);
    }

    @Override
    public List<JSONObject> trainEquipmentPancake(TrainReqVo reqVo) {
        return ((BizTrainEquipmentDataDao)this.baseMapper).trainEquipmentPancake(reqVo);
    }
}

