package com.artfess.portal.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.model.Tree;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 新闻分类
 * @company 阿特菲斯信息技术有限公司
 * @author 赵祥云
 * @since 2020-07-03
 */
@TableName("PORTAL_NEWS_TREE_")
@ApiModel(value="PortalNewsTree对象", description="")
public class PortalNewsTree extends BaseModel<PortalNewsTree> implements Tree {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "路径")
    @TableField("PATH_")
    private String path;

    @ApiModelProperty(value = "上级id")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "级别(总共有3级)")
    @TableField("RANK_")
    private BigDecimal rank;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private BigDecimal sn;

    @ApiModelProperty(value = "路径名称")
    @TableField("PARENT_NAME_")
    private String parentName;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value="CREATE_TIME_", fill=FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(value="CREATE_BY_", fill=FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "更新时间")
    @TableField(value="UPDATE_TIME_", fill=FieldFill.UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "更新人")
    @TableField(value="UPDATE_BY_", fill=FieldFill.UPDATE)
    private String updateBy;

    @ApiModelProperty(value = "首页栏目高度")
    @TableField("COL_HEIGHT_")
    private BigDecimal colHeight;

    @ApiModelProperty(value = "首页栏目ID")
    @TableField("COLUMN_ID_")
    private String columnId;

    @ApiModelProperty(value = "轮播图间隔时间")
    @TableField("INTERVAL_TIME_")
    private BigDecimal intervalTime;

    @ApiModelProperty(value = "是否发布到首页 0：未发布  1：已发布")
    @TableField("MOBILE_ISSUE_")
    private BigDecimal mobileIssue;

    public BigDecimal getIntervalTime() {
		return intervalTime;
	}

	public void setIntervalTime(BigDecimal intervalTime) {
		this.intervalTime = intervalTime;
	}

	public BigDecimal getColHeight() {
		return colHeight;
	}

	public void setColHeight(BigDecimal colHeight) {
		this.colHeight = colHeight;
	}

	public String getColumnId() {
		return columnId;
	}

	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}

	@TableField(exist=false)
	protected List<SysMenu> children = new ArrayList<SysMenu>();

	@ApiModelProperty(name = "isParent", notes = "是否父节点")
	@TableField(exist=false)
	protected String isParent;// 是否有子节点数据

	@ApiModelProperty(name = "check", notes = "是否选中")
	@TableField(exist=false)
	protected String check;// 是否有子节点数据

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }
    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
    public BigDecimal getRank() {
        return rank;
    }

    public void setRank(BigDecimal rank) {
        this.rank = rank;
    }
    public BigDecimal getSn() {
        return sn;
    }

    public void setSn(BigDecimal sn) {
        this.sn = sn;
    }
    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PortalNewsTree{" +
            "id=" + id +
            ", name=" + name +
            ", path=" + path +
            ", parentId=" + parentId +
            ", rank=" + rank +
            ", sn=" + sn +
            ", parentName=" + parentName +
            ", tenantId=" + tenantId +
            ", createTime=" + createTime +
            ", createBy=" + createBy +
            ", updateTime=" + updateTime +
            ", updateBy=" + updateBy +
        "}";
    }
    @Override
	@JsonIgnore
	public String getText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List getChildren() {
		return children;
	}

	@Override
	public void setChildren(List children) {
		this.children = children;

	}

	@Override
	public void setIsParent(String isParent) {
		// TODO Auto-generated method stub
	}

    public BigDecimal getMobileIssue() {
        return mobileIssue;
    }

    public void setMobileIssue(BigDecimal mobileIssue) {
        this.mobileIssue = mobileIssue;
    }
}
