package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 专业装备
 */
@Getter
public enum SysTypeEnum {
    zy("1", "专业"),

    zb("2", "装备"),



    ;

    SysTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        SysTypeEnum[] values = values();
        for (SysTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        SysTypeEnum[] values = values();
        for (SysTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
