package com.artfess.base.service;

import com.artfess.base.feign.SystemConfigFeignService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;



/**
 * 获取系统属性的服务类
 * <p>添加了缓存</p>
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年6月16日
 */
@Service
public class PropertyService {
	@Resource
    SystemConfigFeignService systemConfigFeignService;

	public String getProperty(String alias, String defaultValue) {
		return systemConfigFeignService.getByAlias(alias, defaultValue);
	}
}
