package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 训练知识分类 1：教学资源、2：装备知识、3：法规文件
 */
@Getter
public enum TeachingTypelEnum {
    zxzy("1", "教学资源"),

    zbzs("2", "装备知识"),

    fgwj("3", "法规文件"),

    ;

    TeachingTypelEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        TeachingTypelEnum[] values = values();
        for (TeachingTypelEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        TeachingTypelEnum[] values = values();
        for (TeachingTypelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
