package com.artfess.examine.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 考生信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-31
 */
@Data
public class UserInfoVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "考生id")
    private String userId;

    @ApiModelProperty(value = "考试姓名")
    private String userName;

    @ApiModelProperty(value = "岗位id")
    private String positionId;

    @ApiModelProperty(value = "性别")
    private String sex;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 账号
     */
    @ApiModelProperty(name = "account", notes = "账号")
    protected String account;


    @ApiModelProperty(value = "评定")
    private Integer level;

    @ApiModelProperty(value = "课目")
    private String subjectName;

}
