package com.artfess.examine.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 考生信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-31
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserEvaluationVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "考生id")
    private String userId;

    @ApiModelProperty(value = "考试姓名")
    private String userName;

    @ApiModelProperty(value = "岗位id")
    private String positionId;

    @ApiModelProperty(value = "科目名称")
    private String subjectName;

    @ApiModelProperty(value = "科目id")
    private List<String> subjectIds ;

    @ApiModelProperty(value = "年份")
    protected String year;

    @ApiModelProperty(value = "组织ID")
    private String orgId;

    @ApiModelProperty(value = "组织姓名")
    private String orgName;

    @ApiModelProperty(value = "最后评定时间")
    private LocalDateTime evaluationTime;

    @ApiModelProperty(value = "评价等级")
    private Integer level;

    /**
     * 0： 非负责人 ， 1: 负责人， 2 部门的主负责人
     */
    @ApiModelProperty(name = "isCharge", notes = "0： 非负责人 ， 1: 负责人， 2 部门的主负责人")
    public String isCharge;


}
