package com.artfess.examine.manager.impl;

import com.artfess.base.enums.EnableStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.examine.dao.ExamNoticeDao;
import com.artfess.examine.manager.ExamNoticeManager;
import com.artfess.examine.model.ExamNotice;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;

/**
 * 通知公告 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Service
public class ExamNoticeManagerImpl extends BaseManagerImpl<ExamNoticeDao, ExamNotice> implements ExamNoticeManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean modifyTopStatus(ExamNotice entity) {
        Assert.hasText(entity.getId(), "请选择要置顶的公告");
        UpdateWrapper<ExamNotice> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("top_status_", "0");
        this.baseMapper.update(null, updateWrapper);
        ExamNotice examNotice = this.baseMapper.selectById(entity.getId());
        if("1".equals(examNotice.getTopStatus())) {
            examNotice.setTopStatus("0");
        }else {
            examNotice.setTopStatus("1");
        }

        int i = this.baseMapper.updateById(examNotice);
        if(i > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean modifyStatus(ExamNotice t) {

        ExamNotice entity = getById(t.getId());
        if (null == entity) {
            return false;
        }

        entity.setStatus(EnableStatusEnum.Y.getType().equals(entity.getStatus()) ? EnableStatusEnum.N.getType() : EnableStatusEnum.Y.getType());
        entity.setUpdateTime(LocalDateTime.now());
        boolean b = this.saveOrUpdate(entity);
        return b;
    }
}
