package com.artfess.examine.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.examine.manager.ExamMaterialTypeAuthManager;
import com.artfess.examine.model.ExamMaterialAuth;
import com.artfess.examine.vo.ExamMaterialVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 资料分类授权表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Slf4j
@RestController
@Api(tags = "基础数据-资料分类授权")
@RequestMapping("/exam/materialType/auth/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamMaterialTypeAuthController extends BaseController<ExamMaterialTypeAuthManager, ExamMaterialAuth> {

    @PostMapping("/saveOrUpdate")
    @ApiOperation("资料授权保存")
    public CommonResult<String> saveOrUpdate(@ApiParam(name = "model", value = "资料授权保存") @RequestBody ExamMaterialVo auth) {
        log.info("资料分类授权保存请求参数:{}", JSON.toJSONString(auth));
        baseService.saveAuth(auth);
        return new CommonResult<>();
    }

    @GetMapping("/findByTypeId")
    @ApiOperation("根据资料id获取所有授权对象")
    public CommonResult<String> findByTemplateClassId(@ApiParam(name="typeId", value="实体typeId") @RequestParam String typeId) {
        return CommonResult.success(baseService.findByTypeId(typeId), null);
    }

}
