package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * xxx成绩与奖惩表（按年度统计成绩与奖惩统计表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@ApiModel(value="BizUserGradeStatic对象", description="xxx成绩与奖惩表（按年度统计成绩与奖惩统计表）")
public class BizUserGradeStatic extends BaseModel<BizUserGradeStatic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "统计年度")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "历年xxx成绩评定描述")
    @TableField("grade_content_")
    private String gradeContent;

    @ApiModelProperty(value = "历年xxx奖惩描述")
    @TableField("rewards_content_")
    private String rewardsContent;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserArchiveId() {
        return userArchiveId;
    }

    public void setUserArchiveId(String userArchiveId) {
        this.userArchiveId = userArchiveId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIdentiCard() {
        return identiCard;
    }

    public void setIdentiCard(String identiCard) {
        this.identiCard = identiCard;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getGradeContent() {
        return gradeContent;
    }

    public void setGradeContent(String gradeContent) {
        this.gradeContent = gradeContent;
    }

    public String getRewardsContent() {
        return rewardsContent;
    }

    public void setRewardsContent(String rewardsContent) {
        this.rewardsContent = rewardsContent;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserGradeStatic{" +
            "id=" + id +
            ", userArchiveId=" + userArchiveId +
            ", userName=" + userName +
            ", identiCard=" + identiCard +
            ", year=" + year +
            ", gradeContent=" + gradeContent +
            ", rewardsContent=" + rewardsContent +
        "}";
    }
}
