package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 训练消耗数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizTrainingData对象", description="训练消耗数据")
public class BizTrainingData extends AutoFillModel<BizTrainingData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择指标", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标id")
    @TableField("index_id_")
    private String indexId;

    @Excel(name = "指标名称", column = "A")
    @NotNull(message = "指标名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "指标名称")
    @TableField(exist = false)
    private String indexName;

    @Excel(name = "数量", column = "B")
    @NotNull(message = "请填写数量", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "数量")
    @TableField("number_")
    private BigDecimal number;

    @Excel(name = "出入库类型", column = "C")
    @NotNull(message = "请选择出入库类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "出入库类型【1：入库、2：出库】")
    @TableField("operate_type_")
    private String operateType;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

}
