package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 训练问题数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@FieldRepeat(fields = {"planId"},message = "该计划已记录训练问题数据",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="BizTrainQuestionData对象", description="训练问题数据")
public class BizTrainQuestionData extends AutoFillModel<BizTrainQuestionData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "年度", column = "A")
    @ApiModelProperty(value = "年度")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "计划id")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "B")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "训练课目", column = "C")
    @ApiModelProperty(value = "训练课目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "训练课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "训练过程中基本动作", column = "D")
    @ApiModelProperty(value = "训练过程中基本动作")
    @TableField("process_action_")
    private String processAction;

    @Excel(name = "流程方案", column = "E")
    @ApiModelProperty(value = "流程方案")
    @TableField("process_scheme_")
    private String processScheme;

    @Excel(name = "训练组织", column = "F")
    @ApiModelProperty(value = "训练组织")
    @TableField("train_org_")
    private String trainOrg;

    @Excel(name = "思想状态", column = "G")
    @ApiModelProperty(value = "思想状态")
    @TableField("status_")
    private String status;

    @Excel(name = "备注", column = "H")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

}
