package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 课目训练基础数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizSubjectBaseData对象", description="课目训练基础数据")
public class BizSubjectBaseData extends AutoFillModel<BizSubjectBaseData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "课目名称", column = "A")
    @ApiModelProperty(value = "课目名称")
    @TableField("subject_name_")
    private String subjectName;

    @Excel(name = "训练内容", column = "B")
    @ApiModelProperty(value = "训练内容")
    @TableField("train_content_")
    private String trainContent;

    @Excel(name = "应训时间", column = "C")
    @ApiModelProperty(value = "应训时间")
    @TableField("train_time_")
    private LocalDate trainTime;

    @Excel(name = "训练条件", column = "D")
    @ApiModelProperty(value = "训练条件")
    @TableField("train_condition_")
    private String trainCondition;

    @Excel(name = "考核标准", column = "E")
    @ApiModelProperty(value = "考核标准")
    @TableField("assessment_criteria_")
    private String assessmentCriteria;

    @Excel(name = "教练员姓名", column = "F")
    @ApiModelProperty(value = "教练员姓名")
    @TableField("couch_name_")
    private String couchName;

    @ApiModelProperty(value = "教练员")
    @TableField("couch_id_")
    private String couchId;

    @Excel(name = "训练场地", column = "G")
    @ApiModelProperty(value = "训练场地")
    @TableField("training_addr_")
    private String trainingAddr;

    @Excel(name = "考核员", column = "H")
    @ApiModelProperty(value = "考核员")
    @TableField("examiner_")
    private String examiner;

    @Excel(name = "考核时间", column = "I")
    @ApiModelProperty(value = "考核时间")
    @TableField("exam_time_")
    private LocalDate examTime;

    @Excel(name = "备注", column = "J")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
