package com.artfess.data.model;

import java.math.BigDecimal;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 训练计划关联课目
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-12-12
 */
@Data
@ApiModel(value="BizExamPlanSubject对象", description="训练计划关联课目")
public class BizExamPlanSubject extends BaseModel<BizExamPlanSubject> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "总计划id")
    @TableField("general_plan_id_")
    private String generalPlanId;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @ApiModelProperty(value = "训练课目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "训练课目id")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "训练时长(h)")
    @TableField("hour_")
    private BigDecimal hour;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "last_time_", fill = FieldFill.INSERT_UPDATE, select = true)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "开始时间")
    @TableField("start_time_")
    private LocalDate startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("end_time_")
    private LocalDate endTime;

    @ApiModelProperty(value = "训练科目添加的类型，1-关联科目信息，2-自定义科目信息")
    @TableField("type_")
    private Integer type;

    @Excel(name = "训练等级", column = "E")
    @ApiModelProperty(value = "训练等级")
    @TableField(exist = false)
    private String trainLevel;

    @ApiModelProperty(value = "应训人数（人）")
    @TableField(exist = false)
    private Long totalNum;

    @ApiModelProperty(value = "已训人数（人）")
    @TableField(exist = false)
    private Long realityNum;

    @ApiModelProperty(value = "训练场地id")
    @TableField(exist = false)
    private String spaceId;

    @ApiModelProperty(value = "训练场地")
    @TableField(exist = false)
    private String spaceName;

    @ApiModelProperty(value = "教练员ID")
    @TableField(exist = false)
    private String coachId;

    @ApiModelProperty(value = "教练员")
    @TableField(exist = false)
    private String coachName;

    @ApiModelProperty(value = "主训员id")
    @TableField(exist = false)
    private String mainUserId;

    @ApiModelProperty(value = "主训员")
    @TableField(exist = false)
    private String mainUserName;

    @ApiModelProperty(value = "训练方式【字典】（1：集中组织、2：自行学习）")
    @TableField(exist = false)
    private String way;

    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    @TableField(exist = false)
    private String trainType;

    @ApiModelProperty(value = "训练内容及要求")
    @TableField(exist = false)
    private String trainContent;


    @ApiModelProperty(value = "专业id")
    @TableField(exist = false)
    private String majorId;

    @ApiModelProperty(value = "专业")
    @TableField(exist = false)
    private String majorName;


}
