/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamFileManager;
import com.artfess.examine.manager.ExamMaterialInfoManager;
import com.artfess.examine.model.ExamFile;
import com.artfess.examine.model.ExamMaterialInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u8d44\u6599\u4fe1\u606f"})
@RequestMapping(value={"/exam/materialType/info/"})
@ApiGroup(group={"group_biz"})
public class ExamMaterialInfoController
extends BaseController<ExamMaterialInfoManager, ExamMaterialInfo> {
    private static final Logger log = LoggerFactory.getLogger(ExamMaterialInfoController.class);
    @Autowired
    private ExamFileManager fileManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamMaterialInfo t) {
        String id = ((ExamMaterialInfoManager)this.baseService).createInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamMaterialInfo t) {
        String id = ((ExamMaterialInfoManager)this.baseService).updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6id\u5220\u9664\u8d44\u6599\u9644\u4ef6\u4fe1\u606f")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        ExamFile examFile = (ExamFile)this.fileManager.get((Serializable)((Object)id));
        if (null == examFile) {
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        boolean result = this.fileManager.removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u9644\u4ef6\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ExamMaterialInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamMaterialInfo> queryFilter) {
        return ((ExamMaterialInfoManager)this.baseService).findByPage(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public ExamMaterialInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamMaterialInfoManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/viewFile/{id}"})
    @ApiOperation(value="\u67e5\u770b\u6587\u4ef6")
    public ExamMaterialInfo viewFile(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamMaterialInfoManager)this.baseService).viewFile(id);
    }
}

