/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.SyncAnnotation;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizUserCheckManager;
import com.artfess.data.model.BizUserCheck;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u4eba\u5458\u8003\u52e4\u6570\u636e"})
@RequestMapping(value={"/biz/userCheck/"})
@ApiGroup(group={"group_biz"})
public class BizUserCheckController
extends BaseController<BizUserCheckManager, BizUserCheck> {
    private static final Logger log = LoggerFactory.getLogger(BizUserCheckController.class);

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53(\u4fee\u6539\u8003\u52e4\u72b6\u6001)")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizUserCheck t) {
        BizUserCheck userCheck = (BizUserCheck)this.getById(t.getId());
        userCheck.setStatus("1");
        userCheck.setTrainFile(t.getTrainFile());
        boolean result = ((BizUserCheckManager)this.baseService).updateById((Object)userCheck);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizUserCheck> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizUserCheck> queryFilter) {
        return ((BizUserCheckManager)this.baseService).query(queryFilter);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, String planId) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(BizUserCheck.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            ((BizUserCheckManager)this.baseService).importList(list, planId);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizUserCheck> queryFilter) throws Exception {
        PageList<BizUserCheck> page = this.query(queryFilter);
        ExcelUtils util = new ExcelUtils(BizUserCheck.class);
        util.exportExcel(response, request, page.getRows(), "\u4eba\u5458\u8003\u52e4\u6570\u636e");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u6d3b\u52a8\u6570\u636e/\u4eba\u5458\u8003\u52e4\u6570\u636e.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u4eba\u5458\u8003\u52e4\u6570\u636e\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @SyncAnnotation(httpMethod="post")
    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u4fee\u6539\u8003\u52e4\u72b6\u6001")
    public CommonResult<String> updateStatus(String ... ids) {
        List userCheckList = ((BizUserCheckManager)this.baseService).listByIds(Arrays.asList(ids));
        userCheckList.forEach(check -> check.setStatus("1"));
        boolean result = ((BizUserCheckManager)this.baseService).updateBatchById(userCheckList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

