/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.enums.TrainTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.ConvertUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WordUtil;
import com.artfess.data.vo.ArchivesManagerVo;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.dao.ExamPaperBaseDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.dao.ExamUserEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.dao.ExamUserRecordDao;
import com.artfess.examine.dao.ExamYearAssessmentSubDao;
import com.artfess.examine.dao.ExamYearReportDao;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.model.ExamYearAssessmentSub;
import com.artfess.examine.vo.SettingYearVo;
import com.artfess.examine.vo.UserEvaluationVo;
import com.artfess.examine.vo.UserInfoVo;
import com.artfess.file.util.AppFileUtil;
import com.artfess.poi.HeaderNode;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.FileDownloadUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExamUserEvaluationManagerImpl
extends BaseManagerImpl<ExamUserEvaluationDao, ExamUserEvaluation>
implements ExamUserEvaluationManager {
    @Resource
    private ExamYearAssessmentSubDao yearAssessmentSubDao;
    @Resource
    private ExamPaperBaseDao paperBaseDao;
    @Resource
    private ExamUserEvaluationDetailDao userEvaluationDetailDao;
    @Resource
    private ExamUserRecordDao userRecordDao;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Resource
    private ExamYearReportDao yearReportDao;
    @Autowired
    private ExamUserEvaluationDetailManager userEvaluationDetailManager;
    @Autowired
    private ExamUserEvaluationManager userEvaluationManager;

    @Override
    public PageList<ExamUserEvaluation> findByPage(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamUserEvaluation> result = ((ExamUserEvaluationDao)this.baseMapper).findByPage((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void userEvaluation(ExamUserRecord userRecord) {
        if (StringUtils.isEmpty((CharSequence)userRecord.getPositionId())) {
            return;
        }
        String year = String.valueOf(LocalDateTime.now().getYear());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"position_id_", (Object)userRecord.getPositionId());
        queryWrapper.eq((Object)"year_", (Object)year);
        List subList = this.yearAssessmentSubDao.selectList((Wrapper)queryWrapper);
        List<String> subjectIds = subList.stream().map(ExamYearAssessmentSub::getSubjectIds).collect(Collectors.toList());
        String subjectName = subList.stream().map(ExamYearAssessmentSub::getSubjectName).collect(Collectors.joining(",", "", ""));
        if (CollectionUtils.isEmpty(subjectIds)) {
            return;
        }
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseDao.selectById((Serializable)((Object)userRecord.getPaperId())));
        if (null == examPaperBase) {
            return;
        }
        if (!"2".equals(examPaperBase.getPaperType())) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)examPaperBase.getSubjectId())) {
            return;
        }
        boolean flag = false;
        if (subjectIds.contains(examPaperBase.getSubjectId())) {
            flag = true;
        }
        if (!flag) {
            return;
        }
        this.processUserEvaluationDetail(examPaperBase, userRecord);
        UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(userRecord.getUserId()).subjectIds(subjectIds).subjectName(subjectName).positionId(userRecord.getPositionId()).year(year).build();
        this.evaluationScore(userEvaluationVo);
    }

    private void evaluationScore(UserEvaluationVo userEvaluationVo) {
        String year = String.valueOf(LocalDateTime.now().getYear());
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.eq((Object)"year_", (Object)year);
        detailQueryWrapper.eq((Object)"position_id_", (Object)userEvaluationVo.getPositionId());
        detailQueryWrapper.eq((Object)"user_id_", (Object)userEvaluationVo.getUserId());
        detailQueryWrapper.isNotNull((Object)"level_");
        List list = this.userEvaluationDetailDao.selectList((Wrapper)detailQueryWrapper);
        int totalCount = 0;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)userEvaluationVo.getPositionId());
        query.eq((Object)"year_", (Object)String.valueOf(LocalDateTime.now().getYear()));
        query.eq((Object)"user_id_", (Object)userEvaluationVo.getUserId());
        ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectOne((Wrapper)query));
        if (!CollectionUtils.isEmpty(userEvaluationVo.getSubjectIds())) {
            totalCount = userEvaluationVo.getSubjectIds().size();
        }
        Integer level = null;
        int inCount = list.size();
        if (null == examUserEvaluation) {
            examUserEvaluation = new ExamUserEvaluation();
            examUserEvaluation.setYear(String.valueOf(LocalDateTime.now().getYear()));
            examUserEvaluation.setPositionId(userEvaluationVo.getPositionId());
            examUserEvaluation.setUserId(userEvaluationVo.getUserId());
            examUserEvaluation.setUserName(userEvaluationVo.getUserName());
            examUserEvaluation.setInCount(1);
            if (CollectionUtils.isEmpty(userEvaluationVo.getSubjectIds())) {
                totalCount = 1;
                examUserEvaluation.setNotCount(0);
            } else {
                examUserEvaluation.setNotCount(userEvaluationVo.getSubjectIds().size() - 1);
            }
            examUserEvaluation.setTotalCount(totalCount);
            examUserEvaluation.setSubjectName(userEvaluationVo.getSubjectName());
            ((ExamUserEvaluationDao)this.baseMapper).insert((Object)examUserEvaluation);
        } else {
            if (CollectionUtils.isEmpty(userEvaluationVo.getSubjectIds())) {
                totalCount = examUserEvaluation.getTotalCount() + 1;
            }
            if (inCount < totalCount) {
                examUserEvaluation.setInCount(inCount);
                examUserEvaluation.setNotCount(totalCount - inCount);
            }
            examUserEvaluation.setTotalCount(totalCount);
            examUserEvaluation.setLevel(null);
            examUserEvaluation.setEvaluationTime(null);
            if (!CollectionUtils.isEmpty((Collection)list) && inCount == totalCount) {
                examUserEvaluation.setEvaluationTime(LocalDateTime.now());
                Map<Integer, List<ExamUserEvaluationDetail>> map = list.stream().collect(Collectors.groupingBy(ExamUserEvaluationDetail::getLevel));
                int goodCount = 0;
                int lhCount = 0;
                int jgCount = 0;
                int bjgCount = 0;
                if (map.containsKey(ScoreLevelEnum.GOOD.getType())) {
                    goodCount = map.get(ScoreLevelEnum.GOOD.getType()).size();
                }
                if (map.containsKey(ScoreLevelEnum.LH.getType())) {
                    lhCount = map.get(ScoreLevelEnum.LH.getType()).size();
                }
                if (map.containsKey(ScoreLevelEnum.JG.getType())) {
                    jgCount = map.get(ScoreLevelEnum.JG.getType()).size();
                }
                if (map.containsKey(ScoreLevelEnum.BJG.getType())) {
                    bjgCount = map.get(ScoreLevelEnum.BJG.getType()).size();
                }
                level = lhCount + goodCount == totalCount && (double)totalCount * 0.5 <= (double)goodCount || jgCount + lhCount + goodCount == totalCount && (double)totalCount * 0.8 <= (double)goodCount ? ScoreLevelEnum.GOOD.getType() : (jgCount + lhCount + goodCount == totalCount && (double)totalCount * 0.5 <= (double)(goodCount + lhCount) ? ScoreLevelEnum.LH.getType() : ((double)totalCount * 0.5 <= (double)goodCount && (double)totalCount * 0.8 <= (double)(jgCount + lhCount + goodCount) || (double)totalCount * 0.9 <= (double)(jgCount + lhCount + goodCount) ? ScoreLevelEnum.JG.getType() : ScoreLevelEnum.BJG.getType()));
                examUserEvaluation.setLevel(level);
            }
            examUserEvaluation.setSubjectName(userEvaluationVo.getSubjectName());
            ((ExamUserEvaluationDao)this.baseMapper).updateById((Object)examUserEvaluation);
        }
    }

    private void processUserEvaluationDetail(ExamPaperBase examPaperBase, ExamUserRecord userRecord) {
        if (StringUtils.isEmpty((CharSequence)examPaperBase.getEndStatus()) || "0".equals(examPaperBase.getEndStatus())) {
            return;
        }
        String year = String.valueOf(LocalDateTime.now().getYear());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)examPaperBase.getSubjectId());
        queryWrapper.eq((Object)"year_", (Object)year);
        queryWrapper.eq((Object)"position_id_", (Object)userRecord.getPositionId());
        queryWrapper.eq((Object)"user_id_", (Object)userRecord.getUserId());
        ExamUserEvaluationDetail examUserEvaluationDetail = (ExamUserEvaluationDetail)((Object)this.userEvaluationDetailDao.selectOne((Wrapper)queryWrapper));
        if (null == examUserEvaluationDetail) {
            examUserEvaluationDetail = new ExamUserEvaluationDetail();
            examUserEvaluationDetail.setPositionId(userRecord.getPositionId());
            examUserEvaluationDetail.setSubjectId(examPaperBase.getSubjectId());
            examUserEvaluationDetail.setUserId(userRecord.getUserId());
            examUserEvaluationDetail.setUserName(userRecord.getUserName());
            examUserEvaluationDetail.setYear(year);
            examUserEvaluationDetail.setRecordId(userRecord.getId());
            examUserEvaluationDetail.setLevel(userRecord.getLevel());
            this.userEvaluationDetailDao.insert((Object)examUserEvaluationDetail);
        } else {
            examUserEvaluationDetail.setRecordId(userRecord.getId());
            examUserEvaluationDetail.setLevel(userRecord.getLevel());
            this.userEvaluationDetailDao.updateById((Object)examUserEvaluationDetail);
        }
    }

    @Override
    public PageList<ExamUserEvaluation> myYearPage(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamUserEvaluation> result = ((ExamUserEvaluationDao)this.baseMapper).myYearPage((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addSubject(ExamUserEvaluation t) {
        Assert.hasText((String)t.getId(), (String)"\u8bf7\u9009\u62e9\u8981\u589e\u52a0\u8bfe\u76ee\u7684\u8003\u751f");
        if (StringUtil.isEmpty((String)t.getSubjectId())) {
            return true;
        }
        ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        List<String> subjectIds = Arrays.asList(t.getSubjectId().split(","));
        subjectIds.forEach(subjectId -> {
            if (examUserEvaluation.getSubjectId().contains((CharSequence)subjectId)) {
                throw new BaseException("\u589e\u52a0\u7684\u8bfe\u76ee\u4e2d\u6709\u5df2\u7ecf\u52a0\u5165\u5e74\u5ea6\u8003\u6838\u7684\u8bfe\u76ee\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
            }
        });
        examUserEvaluation.setSubjectId(examUserEvaluation.getSubjectId() + "," + t.getSubjectId());
        examUserEvaluation.setSubjectName(examUserEvaluation.getSubjectName() + "," + t.getSubjectName());
        int i = ((ExamUserEvaluationDao)this.baseMapper).updateById((Object)examUserEvaluation);
        if (i > 0) {
            UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(examUserEvaluation.getUserId()).subjectIds(Arrays.asList(examUserEvaluation.getSubjectId().split(","))).subjectName(examUserEvaluation.getSubjectName()).positionId(examUserEvaluation.getPositionId()).year(examUserEvaluation.getYear()).build();
            this.evaluationScore(userEvaluationVo);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delSubject(ExamUserEvaluation t) {
        Assert.hasText((String)t.getId(), (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u8bfe\u76ee\u7684\u8003\u751f");
        if (StringUtil.isEmpty((String)t.getSubjectId())) {
            return true;
        }
        ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        String afterSubjectId = examUserEvaluation.getSubjectId();
        ArrayList<String> afterSubjectIds = new ArrayList<String>(Arrays.asList(afterSubjectId.split(",")));
        ArrayList<String> afterSubjectNames = new ArrayList<String>(Arrays.asList(examUserEvaluation.getSubjectName().split(",")));
        List<String> subjectIds = Arrays.asList(t.getSubjectId().split(","));
        subjectIds.forEach(subjectId -> {
            if (!afterSubjectId.contains((CharSequence)subjectId)) {
                throw new BaseException("\u5220\u9664\u7684\u8bfe\u76ee\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u8bfe\u76ee\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
            }
            afterSubjectIds.remove(subjectId);
        });
        Arrays.asList(t.getSubjectName().split(",")).forEach(subjectName -> afterSubjectNames.remove(subjectName));
        examUserEvaluation.setSubjectId(String.join((CharSequence)",", afterSubjectIds));
        examUserEvaluation.setSubjectName(String.join((CharSequence)",", afterSubjectNames));
        int i = ((ExamUserEvaluationDao)this.baseMapper).updateById((Object)examUserEvaluation);
        if (i > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"subject_id_", subjectIds);
            queryWrapper.eq((Object)"year_", (Object)examUserEvaluation.getYear());
            queryWrapper.eq((Object)"position_id_", (Object)examUserEvaluation.getPositionId());
            queryWrapper.eq((Object)"user_id_", (Object)examUserEvaluation.getUserId());
            this.userEvaluationDetailDao.delete((Wrapper)queryWrapper);
            UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(examUserEvaluation.getUserId()).subjectIds(Arrays.asList(examUserEvaluation.getSubjectId().split(","))).subjectName(examUserEvaluation.getSubjectName()).positionId(examUserEvaluation.getPositionId()).year(examUserEvaluation.getYear()).build();
            this.evaluationScore(userEvaluationVo);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean settingYear(SettingYearVo t) {
        Assert.hasText((String)t.getId(), (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u5e74\u5ea6\u8003\u6838\u6210\u7ee9\u7684\u8003\u751f");
        Assert.hasText((String)t.getRecordId(), (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u5e74\u5ea6\u8003\u6838\u7684\u6210\u7ee9\u4fe1\u606f");
        ExamUserRecord userRecord = (ExamUserRecord)((Object)this.userRecordDao.selectById((Serializable)((Object)t.getRecordId())));
        Assert.notNull((Object)((Object)userRecord), (String)"\u8003\u8bd5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseDao.selectById((Serializable)((Object)userRecord.getPaperId())));
        if (null == examPaperBase) {
            return false;
        }
        ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)examPaperBase.getSubjectId());
        queryWrapper.eq((Object)"year_", (Object)examUserEvaluation.getYear());
        queryWrapper.eq((Object)"position_id_", (Object)examUserEvaluation.getPositionId());
        queryWrapper.eq((Object)"user_id_", (Object)examUserEvaluation.getUserId());
        ExamUserEvaluationDetail examUserEvaluationDetail = (ExamUserEvaluationDetail)((Object)this.userEvaluationDetailDao.selectOne((Wrapper)queryWrapper));
        if (null == examUserEvaluationDetail) {
            examUserEvaluationDetail = new ExamUserEvaluationDetail();
            examUserEvaluationDetail.setPositionId(userRecord.getPositionId());
            examUserEvaluationDetail.setSubjectId(examPaperBase.getSubjectId());
            examUserEvaluationDetail.setUserId(userRecord.getUserId());
            examUserEvaluationDetail.setUserName(userRecord.getUserName());
            examUserEvaluationDetail.setYear(examUserEvaluation.getYear());
            examUserEvaluationDetail.setRecordId(userRecord.getId());
            examUserEvaluationDetail.setLevel(userRecord.getLevel());
            examUserEvaluationDetail.setScore(String.valueOf(userRecord.getSysScore()));
            examUserEvaluationDetail.setType("1");
            examUserEvaluationDetail.setSubjectName(examPaperBase.getSubjectName());
            this.userEvaluationDetailDao.insert((Object)examUserEvaluationDetail);
        } else {
            examUserEvaluationDetail.setScore(String.valueOf(userRecord.getSysScore()));
            examUserEvaluationDetail.setType("1");
            examUserEvaluationDetail.setSubjectName(examPaperBase.getSubjectName());
            examUserEvaluationDetail.setRecordId(userRecord.getId());
            examUserEvaluationDetail.setLevel(userRecord.getLevel());
            this.userEvaluationDetailDao.updateById((Object)examUserEvaluationDetail);
        }
        UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(examUserEvaluation.getUserId()).subjectIds(Arrays.asList(examUserEvaluation.getSubjectId().split(","))).subjectName(examUserEvaluation.getSubjectName()).positionId(examUserEvaluation.getPositionId()).year(examUserEvaluation.getYear()).build();
        this.evaluationScore(userEvaluationVo);
        return true;
    }

    @Override
    public List<ExamUserEvaluationDetail> evaluationDetail(String id) {
        ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == examUserEvaluation) {
            return Lists.newArrayList();
        }
        if (StringUtil.isEmpty((String)examUserEvaluation.getSubjectId())) {
            return Lists.newArrayList();
        }
        ArrayList<String> subjectIds = new ArrayList<String>(Arrays.asList(examUserEvaluation.getSubjectId().split(",")));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"subject_id_", subjectIds);
        queryWrapper.eq((Object)"year_", (Object)examUserEvaluation.getYear());
        queryWrapper.eq((Object)"position_id_", (Object)examUserEvaluation.getPositionId());
        queryWrapper.eq((Object)"user_id_", (Object)examUserEvaluation.getUserId());
        List detailList = this.userEvaluationDetailDao.selectList((Wrapper)queryWrapper);
        Map<String, ExamUserEvaluationDetail> detailMap = detailList.stream().collect(Collectors.toMap(item -> item.getSubjectId(), item -> item));
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id_", subjectIds);
        List subjectInfoList = this.subjectInfoDao.selectList((Wrapper)query);
        Map<String, ExamSubjectInfo> sujectMap = subjectInfoList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        ArrayList list = Lists.newArrayList();
        subjectIds.forEach(subjectId -> {
            ExamUserEvaluationDetail examUserEvaluationDetail = new ExamUserEvaluationDetail();
            examUserEvaluationDetail.setPositionId(examUserEvaluation.getPositionId());
            examUserEvaluationDetail.setSubjectId((String)subjectId);
            examUserEvaluationDetail.setUserId(examUserEvaluation.getUserId());
            examUserEvaluationDetail.setUserName(examUserEvaluation.getUserName());
            examUserEvaluationDetail.setYear(examUserEvaluation.getYear());
            if (null != detailMap && detailMap.containsKey(subjectId)) {
                ExamUserEvaluationDetail detail = (ExamUserEvaluationDetail)((Object)((Object)detailMap.get(subjectId)));
                if (StringUtils.isNotEmpty((CharSequence)detail.getRecordId()) && null != detail.getLevel()) {
                    examUserEvaluationDetail.setStatus(1);
                } else {
                    examUserEvaluationDetail.setStatus(0);
                }
                examUserEvaluationDetail.setRecordId(detail.getRecordId());
                examUserEvaluationDetail.setLevel(detail.getLevel());
            }
            if (null != sujectMap && sujectMap.containsKey(subjectId)) {
                ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)((Object)sujectMap.get(subjectId)));
                examUserEvaluationDetail.setSubjectName(examSubjectInfo.getName());
            }
            list.add(examUserEvaluationDetail);
        });
        return list;
    }

    @Override
    public String getReportStatus() {
        String year = String.valueOf(LocalDateTime.now().getYear());
        QueryWrapper yearReportQueryWrapper = new QueryWrapper();
        yearReportQueryWrapper.eq((Object)"year_", (Object)year);
        Integer count = this.yearReportDao.selectCount((Wrapper)yearReportQueryWrapper);
        if (count > 0) {
            return "1";
        }
        return "0";
    }

    @Override
    public List<JSONObject> getSubjectInfo(SettingYearVo t) {
        String year = String.valueOf(LocalDateTime.now().getYear());
        t.setYear(year);
        return ((ExamUserEvaluationDao)this.baseMapper).getSubjectInfo(t);
    }

    @Override
    public List<JSONObject> getPositionPaper(SettingYearVo t) {
        return ((ExamUserEvaluationDao)this.baseMapper).getPositionPaper(t);
    }

    @Override
    public void export(String orgId, HttpServletResponse response, String fileName) throws IOException {
        HashMap rowMap = Maps.newHashMap();
        HashMap columnMap = Maps.newHashMap();
        String year = String.valueOf(LocalDateTime.now().getYear());
        List<UserInfoVo> userList = this.userEvaluationDetailDao.getYearUserList(orgId, year);
        if (CollectionUtils.isEmpty(userList)) {
            throw new BaseException("\u8be5\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u8003\u751f");
        }
        HeaderNode headerNode = null;
        ArrayList list = Lists.newArrayList();
        headerNode = new HeaderNode();
        headerNode.setColumn(0);
        headerNode.setHeaderName("\u5e8f\u53f7");
        headerNode.setRow(1);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(1);
        headerNode.setHeaderName("\u59d3\u540d");
        headerNode.setRow(1);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(2);
        headerNode.setHeaderName("\u6027\u522b");
        headerNode.setRow(1);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(3);
        headerNode.setHeaderName("\u5e74\u9f84");
        headerNode.setRow(1);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(4);
        headerNode.setHeaderName("\u90e8\u804c\u522b");
        headerNode.setRow(1);
        list.add(headerNode);
        List<ExamUserEvaluationDetail> examUserEvaluationDetails = this.userEvaluationDetailDao.findByYearParams(orgId, year);
        if (CollectionUtils.isEmpty(examUserEvaluationDetails)) {
            throw new BaseException("\u8be5\u5c97\u4f4d\u4e0b\u6ca1\u6709\u5e74\u5ea6\u8003\u6838\u6210\u7ee9");
        }
        int useColumn = 4;
        List<JSONObject> subjectNames = ((ExamUserEvaluationDao)this.baseMapper).offineInfo(orgId, year);
        if (!CollectionUtils.isEmpty(subjectNames)) {
            Integer xxksCount = 0;
            for (JSONObject json : subjectNames) {
                Integer n = xxksCount;
                Integer n2 = xxksCount = Integer.valueOf(xxksCount + 1);
                headerNode = new HeaderNode();
                headerNode.setColumn(++useColumn);
                headerNode.setHeaderName("\u8bfe\u76ee" + ConvertUtil.intToChineseNum((Integer)xxksCount));
                headerNode.setRow(2);
                headerNode.setOverNodeCount(2);
                headerNode.setOverNode(false);
                list.add(headerNode);
                headerNode = new HeaderNode();
                headerNode.setColumn(useColumn);
                headerNode.setHeaderName("\u6210\u7ee9");
                headerNode.setRow(3);
                list.add(headerNode);
                columnMap.put(json.getString("subjectname") + "-\u6210\u7ee9", useColumn);
                headerNode = new HeaderNode();
                headerNode.setColumn(++useColumn);
                headerNode.setHeaderName("\u8bc4\u5b9a");
                headerNode.setRow(3);
                list.add(headerNode);
            }
            headerNode = new HeaderNode();
            headerNode.setColumn(useColumn - subjectNames.size() * 2 + 1);
            headerNode.setHeaderName("\u519b\u4e8b\u8bad\u7ec3");
            headerNode.setRow(1);
            headerNode.setOverNodeCount(subjectNames.size() * 2);
            headerNode.setOverNode(false);
            list.add(headerNode);
        }
        List<String> zygtxlSubjectNames = ((ExamUserEvaluationDao)this.baseMapper).zygtxlSubjectNames(orgId, TrainTypeEnum.zygtxl.getType());
        HashMap zygtxlColumnMap = Maps.newHashMap();
        for (int i = 0; i < zygtxlSubjectNames.size(); ++i) {
            headerNode = new HeaderNode();
            headerNode.setColumn(++useColumn);
            String s = ConvertUtil.intToChineseNum((Integer)(i + 1));
            headerNode.setHeaderName("\u8bfe\u76ee" + s);
            headerNode.setRow(2);
            headerNode.setOverNodeCount(2);
            headerNode.setOverNode(false);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(useColumn);
            headerNode.setHeaderName("\u6210\u7ee9");
            headerNode.setRow(3);
            list.add(headerNode);
            zygtxlColumnMap.put("\u8bfe\u76ee" + s, useColumn);
            headerNode = new HeaderNode();
            headerNode.setColumn(++useColumn);
            headerNode.setHeaderName("\u8bc4\u5b9a");
            headerNode.setRow(3);
            list.add(headerNode);
        }
        headerNode = new HeaderNode();
        headerNode.setColumn(useColumn - zygtxlSubjectNames.size() * 2 + 1);
        headerNode.setHeaderName("\u5171\u540c\u8bad\u7ec3");
        headerNode.setRow(1);
        headerNode.setOverNodeCount(zygtxlSubjectNames.size() * 2);
        headerNode.setOverNode(false);
        list.add(headerNode);
        HashMap gwxlColumnMap = Maps.newHashMap();
        List<String> gwxlSubjectNames = ((ExamUserEvaluationDao)this.baseMapper).gwxlSubjectNames(orgId, TrainTypeEnum.gwxl.getType());
        for (int i = 0; i < gwxlSubjectNames.size(); ++i) {
            headerNode = new HeaderNode();
            headerNode.setColumn(++useColumn);
            String s = ConvertUtil.intToChineseNum((Integer)(i + 1));
            headerNode.setHeaderName("\u8bfe\u76ee" + s);
            headerNode.setRow(2);
            headerNode.setOverNodeCount(2);
            headerNode.setOverNode(false);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(useColumn);
            headerNode.setHeaderName("\u6210\u7ee9");
            headerNode.setRow(3);
            list.add(headerNode);
            gwxlColumnMap.put("\u8bfe\u76ee" + s, useColumn);
            headerNode = new HeaderNode();
            headerNode.setColumn(++useColumn);
            headerNode.setHeaderName("\u8bc4\u5b9a");
            headerNode.setRow(3);
            list.add(headerNode);
        }
        headerNode = new HeaderNode();
        headerNode.setColumn(useColumn - gwxlSubjectNames.size() * 2 + 1);
        headerNode.setHeaderName("\u5c97\u4f4d\u8bad\u7ec3");
        headerNode.setRow(1);
        headerNode.setOverNodeCount(gwxlSubjectNames.size() * 2);
        headerNode.setOverNode(false);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(useColumn + 1);
        headerNode.setHeaderName("\u603b\u8bc4");
        headerNode.setRow(1);
        list.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setColumn(0);
        headerNode.setHeaderName(year + "\u5e74\u8bad\u7ec3\u6210\u7ee9\u7edf\u8ba1\u8868");
        headerNode.setRow(0);
        headerNode.setOverNodeCount(useColumn + 2);
        headerNode.setOverNode(false);
        list.add(headerNode);
        int row = 3;
        int size = 0;
        for (UserInfoVo user : userList) {
            headerNode = new HeaderNode();
            headerNode.setColumn(0);
            headerNode.setHeaderName(++size + "");
            headerNode.setRow(++row);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(1);
            headerNode.setHeaderName(user.getUserName());
            headerNode.setRow(row);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(2);
            headerNode.setHeaderName(user.getSex());
            headerNode.setRow(row);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(3);
            headerNode.setHeaderName("\u5e74\u9f84");
            headerNode.setRow(row);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(4);
            headerNode.setHeaderName(user.getOrgName());
            headerNode.setRow(row);
            list.add(headerNode);
            rowMap.put(user.getUserId(), headerNode.getRow());
            headerNode = new HeaderNode();
            headerNode.setColumn(useColumn + 1);
            headerNode.setHeaderName(ScoreLevelEnum.getDesc((Integer)user.getLevel()));
            headerNode.setRow(row);
            list.add(headerNode);
            rowMap.put(user.getUserId(), headerNode.getRow());
        }
        for (ExamUserEvaluationDetail detail : examUserEvaluationDetails) {
            String key;
            if (!rowMap.containsKey(detail.getUserId())) continue;
            int currentRow = (Integer)rowMap.get(detail.getUserId());
            boolean flag = false;
            Integer scoreColumn = null;
            Integer levelColumn = null;
            if (columnMap.containsKey(detail.getSubjectName() + "-\u6210\u7ee9")) {
                scoreColumn = (Integer)columnMap.get(detail.getSubjectName() + "-\u6210\u7ee9");
                levelColumn = scoreColumn + 1;
                flag = true;
            }
            for (Map.Entry entry : zygtxlColumnMap.entrySet()) {
                key = (String)entry.getKey();
                if (!StringUtils.isNotEmpty((CharSequence)detail.getSubjectName()) || !detail.getSubjectName().contains(key)) continue;
                scoreColumn = (Integer)entry.getValue();
                levelColumn = (Integer)entry.getValue() + 1;
                flag = true;
            }
            for (Map.Entry entry : gwxlColumnMap.entrySet()) {
                key = (String)entry.getKey();
                if (!StringUtils.isNotEmpty((CharSequence)detail.getSubjectName()) || !detail.getSubjectName().contains(key)) continue;
                scoreColumn = (Integer)entry.getValue();
                levelColumn = (Integer)entry.getValue() + 1;
                flag = true;
            }
            if (!flag) continue;
            headerNode = new HeaderNode();
            headerNode.setColumn(scoreColumn.intValue());
            headerNode.setHeaderName(detail.getScore());
            headerNode.setRow(currentRow);
            list.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setColumn(levelColumn.intValue());
            headerNode.setHeaderName(ScoreLevelEnum.getDesc((Integer)detail.getLevel()));
            headerNode.setRow(currentRow);
            list.add(headerNode);
        }
        list.sort(Comparator.comparing(HeaderNode::getRow));
        CustomHeader.export((List)list, (HttpServletResponse)response, (String)fileName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSettingYear(SettingYearVo t) {
        Assert.hasText((String)t.getPositionId(), (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u5e74\u5ea6\u8003\u6838\u6210\u7ee9\u7684\u5c97\u4f4d");
        Assert.hasText((String)t.getPaperId(), (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u5e74\u5ea6\u8003\u6838\u7684\u8bd5\u5377");
        Assert.hasText((String)t.getSubjectId(), (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u5e74\u5ea6\u8003\u6838\u7684\u8bfe\u76ee");
        ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)this.subjectInfoDao.selectById((Serializable)((Object)t.getSubjectId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)t.getPositionId());
        query.eq((Object)"paper_id_", (Object)t.getPaperId());
        List userRecords = this.userRecordDao.selectList((Wrapper)query);
        Map<String, ExamUserRecord> userRecordMap = userRecords.stream().collect(Collectors.toMap(item -> item.getUserId(), item -> item));
        String year = String.valueOf(LocalDateTime.now().getYear());
        List<UserInfoVo> userList = this.userEvaluationDetailDao.getUserList(t.getPositionId());
        ArrayList details = Lists.newArrayList();
        userList.forEach(userInfoVo -> {
            ExamUserRecord examUserRecord = null;
            if (userRecordMap.containsKey(userInfoVo.getUserId())) {
                examUserRecord = (ExamUserRecord)((Object)((Object)userRecordMap.get(userInfoVo.getUserId())));
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_id_", (Object)t.getSubjectId());
            queryWrapper.eq((Object)"year_", (Object)year);
            queryWrapper.eq((Object)"position_id_", (Object)t.getPositionId());
            queryWrapper.eq((Object)"user_id_", (Object)userInfoVo.getUserId());
            ExamUserEvaluationDetail examUserEvaluationDetail = (ExamUserEvaluationDetail)((Object)((Object)this.userEvaluationDetailDao.selectOne((Wrapper)queryWrapper)));
            if (null == examUserEvaluationDetail) {
                examUserEvaluationDetail = new ExamUserEvaluationDetail();
                examUserEvaluationDetail.setPositionId(t.getPositionId());
                examUserEvaluationDetail.setSubjectId(t.getSubjectId());
                examUserEvaluationDetail.setUserId(userInfoVo.getUserId());
                examUserEvaluationDetail.setUserName(userInfoVo.getUserName());
                examUserEvaluationDetail.setYear(year);
                if (null != examSubjectInfo) {
                    examUserEvaluationDetail.setSubjectName(examSubjectInfo.getName());
                }
                if (null != examUserRecord) {
                    examUserEvaluationDetail.setRecordId(examUserRecord.getId());
                    examUserEvaluationDetail.setLevel(examUserRecord.getLevel());
                    examUserEvaluationDetail.setType("1");
                    examUserEvaluationDetail.setScore(String.valueOf(examUserRecord.getSysScore()));
                } else {
                    examUserEvaluationDetail.setLevel(ScoreLevelEnum.BJG.getType());
                    examUserEvaluationDetail.setType("1");
                    examUserEvaluationDetail.setScore("0");
                }
                details.add(examUserEvaluationDetail);
            } else {
                if (null != examUserRecord) {
                    examUserEvaluationDetail.setRecordId(examUserRecord.getId());
                    examUserEvaluationDetail.setLevel(examUserRecord.getLevel());
                    examUserEvaluationDetail.setType("1");
                    examUserEvaluationDetail.setScore(String.valueOf(examUserRecord.getSysScore()));
                } else {
                    examUserEvaluationDetail.setLevel(ScoreLevelEnum.BJG.getType());
                    examUserEvaluationDetail.setType("1");
                    examUserEvaluationDetail.setScore("0");
                }
                details.add(examUserEvaluationDetail);
            }
            QueryWrapper userEvaluationQueryWrapper = new QueryWrapper();
            userEvaluationQueryWrapper.eq((Object)"subject_id_", (Object)t.getSubjectId());
            userEvaluationQueryWrapper.eq((Object)"year_", (Object)year);
            userEvaluationQueryWrapper.eq((Object)"position_id_", (Object)t.getPositionId());
            userEvaluationQueryWrapper.eq((Object)"user_id_", (Object)userInfoVo.getUserId());
            ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)((Object)((ExamUserEvaluationDao)this.baseMapper).selectOne((Wrapper)userEvaluationQueryWrapper)));
            if (null == examUserEvaluation) {
                examUserEvaluation = new ExamUserEvaluation();
                examUserEvaluation.setYear(t.getYear());
                examUserEvaluation.setPositionId(t.getPositionId());
                examUserEvaluation.setUserId(userInfoVo.getUserId());
                examUserEvaluation.setUserName(userInfoVo.getUserName());
                examUserEvaluation.setInCount(0);
                examUserEvaluation.setNotCount(1);
                examUserEvaluation.setTotalCount(1);
                examUserEvaluation.setSubjectName(examUserEvaluationDetail.getSubjectName());
                examUserEvaluation.setSubjectId(examUserEvaluationDetail.getSubjectId());
            }
            UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(userInfoVo.getUserId()).subjectIds(Arrays.asList(examUserEvaluation.getSubjectId().split(","))).subjectName(examUserEvaluationDetail.getSubjectName()).positionId(t.getPositionId()).year(year).build();
            this.evaluationScore(userEvaluationVo);
        });
        boolean b = this.userEvaluationDetailManager.saveOrUpdateBatch(details);
        return b;
    }

    @Override
    public boolean importExcel(List<ExamUserEvaluationDetail> detail, String positionId) {
        String year = String.valueOf(LocalDateTime.now().getYear());
        List<UserInfoVo> userList = this.userEvaluationDetailDao.getUserList(positionId);
        Map<String, UserInfoVo> userInfoVoMap = userList.stream().collect(Collectors.toMap(item -> item.getUserName(), item -> item));
        detail.forEach(userEvaluation -> {
            if (userInfoVoMap.containsKey(userEvaluation.getUserName())) {
                userEvaluation.setUserId(((UserInfoVo)userInfoVoMap.get(userEvaluation.getUserName())).getUserId());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_id_", (Object)userEvaluation.getUserId());
            queryWrapper.eq((Object)"subject_name_", (Object)userEvaluation.getSubjectName());
            queryWrapper.eq((Object)"type_", (Object)"2");
            List details = this.userEvaluationDetailDao.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)details)) {
                throw new BaseException("\u8be5\u5c97\u4f4d\u4e0b" + userEvaluation.getUserName() + "\u5df2\u5bfc\u5165" + userEvaluation.getSubjectName() + "\u7ebf\u4e0b\u6210\u7ee9");
            }
            userEvaluation.setUserName(userEvaluation.getUserName());
            userEvaluation.setPositionId(positionId);
            userEvaluation.setType("2");
            userEvaluation.setYear(year);
            userEvaluation.setLevel(ScoreLevelEnum.getType((String)userEvaluation.getLevelDesc()));
            UserEvaluationVo userEvaluationVo = UserEvaluationVo.builder().userId(userEvaluation.getUserId()).subjectName(userEvaluation.getSubjectName()).positionId(userEvaluation.getPositionId()).userName(userEvaluation.getUserName()).year(year).build();
            this.evaluationScore(userEvaluationVo);
        });
        boolean b = this.userEvaluationDetailManager.saveOrUpdateBatch(detail);
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delPositionSubject(String subjectIds, String positionId, String year) {
        ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)this.subjectInfoDao.selectById((Serializable)((Object)subjectIds)));
        if (null == examSubjectInfo) {
            return true;
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)positionId);
        query.eq((Object)"year_", (Object)year);
        query.like((Object)"subject_id_", (Object)subjectIds);
        query.gt((Object)"in_count_", (Object)0);
        List examUserEvaluations = this.userEvaluationManager.list((Wrapper)query);
        if (!CollectionUtils.isEmpty((Collection)examUserEvaluations)) {
            throw new BaseException("\u5f53\u524d\u5c97\u4f4d\u8be5\u8bfe\u76ee\u5df2\u53c2\u4e0e\u8003\u6838\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664");
        }
        QueryWrapper subQuery = new QueryWrapper();
        subQuery.eq((Object)"position_id_", (Object)positionId);
        subQuery.eq((Object)"year_", (Object)year);
        subQuery.eq((Object)"subject_ids_", (Object)subjectIds);
        this.yearAssessmentSubDao.delete((Wrapper)subQuery);
        QueryWrapper UserEvaluationQuery = new QueryWrapper();
        UserEvaluationQuery.eq((Object)"position_id_", (Object)positionId);
        UserEvaluationQuery.eq((Object)"year_", (Object)year);
        examUserEvaluations = this.userEvaluationManager.list((Wrapper)UserEvaluationQuery);
        ArrayList updateUserEvaluationList = Lists.newArrayList();
        ArrayList needDelIds = Lists.newArrayList();
        examUserEvaluations.forEach(examUserEvaluation -> {
            ArrayList ids = Lists.newArrayList(Arrays.asList(examUserEvaluation.getSubjectId().split(",")));
            ArrayList names = Lists.newArrayList(Arrays.asList(examUserEvaluation.getSubjectName().split(",")));
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                ids.removeIf(subjectIds::equals);
            }
            if (!CollectionUtils.isEmpty((Collection)names)) {
                names.removeIf(examSubjectInfo.getName()::equals);
            }
            if (CollectionUtils.isEmpty((Collection)ids) || CollectionUtils.isEmpty((Collection)names)) {
                needDelIds.add(examUserEvaluation.getId());
            } else {
                examUserEvaluation.setSubjectId(ids.stream().collect(Collectors.joining(",", "", "")));
                examUserEvaluation.setSubjectName(names.stream().collect(Collectors.joining(",", "", "")));
                updateUserEvaluationList.add(examUserEvaluation);
            }
        });
        this.saveOrUpdateBatch(updateUserEvaluationList);
        this.removeByIds(needDelIds);
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.in((Object)"subject_id_", new Object[]{subjectIds});
        detailQueryWrapper.eq((Object)"year_", (Object)year);
        detailQueryWrapper.eq((Object)"position_id_", (Object)positionId);
        int delete = this.userEvaluationDetailDao.delete((Wrapper)detailQueryWrapper);
        return true;
    }

    @Override
    public PageList<ArchivesManagerVo> positionArchives(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ArchivesManagerVo> result = ((ExamUserEvaluationDao)this.baseMapper).positionArchives((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(vo -> {
            vo.setId(UniqueIdUtil.getSuid());
            if (0L == vo.getPassCount()) {
                vo.setPassRate("0%");
            } else {
                vo.setPassRate(new BigDecimal(vo.getPassCount()).divide(new BigDecimal(vo.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
            if (0L == vo.getNoPassCount()) {
                vo.setNoPassRate("0%");
            } else {
                vo.setNoPassRate(new BigDecimal(vo.getNoPassCount()).divide(new BigDecimal(vo.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
            if (0L == vo.getActualCount()) {
                vo.setReferRate("0%");
            } else {
                vo.setReferRate(new BigDecimal(vo.getActualCount()).divide(new BigDecimal(vo.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
        });
        return new PageList(result);
    }

    @Override
    public PageList<ArchivesManagerVo> orgArchives(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ArchivesManagerVo> result = ((ExamUserEvaluationDao)this.baseMapper).orgArchives((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(vo -> {
            vo.setId(UniqueIdUtil.getSuid());
            if (0L == vo.getActualCount()) {
                vo.setReferRate("0%");
            } else {
                vo.setReferRate(new BigDecimal(vo.getActualCount()).divide(new BigDecimal(vo.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
        });
        return new PageList(result);
    }

    @Override
    public PageList<ArchivesManagerVo> subjectArchives(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ArchivesManagerVo> result = ((ExamUserEvaluationDao)this.baseMapper).subjectArchives((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        Set<String> postionIds = result.getRecords().stream().map(ArchivesManagerVo::getPositionId).collect(Collectors.toSet());
        List<Object> shouldCountList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(postionIds)) {
            shouldCountList = ((ExamUserEvaluationDao)this.baseMapper).getShouldCountMap(postionIds);
        }
        Map<Object, Object> shouldCountMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)shouldCountList)) {
            shouldCountMap = shouldCountList.stream().collect(Collectors.toMap(item -> item.getPositionId(), item -> item));
        }
        HashMap evaluationMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            List<ArchivesManagerVo> list = ((ExamUserEvaluationDao)this.baseMapper).getEvaluationList(((ArchivesManagerVo)result.getRecords().get(0)).getYear());
            list.forEach(vo -> evaluationMap.put(vo.getPositionId() + vo.getSubjectId() + vo.getYear(), vo));
        }
        HashMap finalShouldCountMap = shouldCountMap;
        result.getRecords().forEach(data -> {
            if (!CollectionUtils.isEmpty((Map)finalShouldCountMap) && null != finalShouldCountMap.get(data.getPositionId())) {
                data.setShouldCount(((ArchivesManagerVo)finalShouldCountMap.get(data.getPositionId())).getShouldCount());
            }
            if (!CollectionUtils.isEmpty((Map)evaluationMap) && null != evaluationMap.get(data.getPositionId() + data.getSubjectId() + data.getYear())) {
                ArchivesManagerVo archivesManagerVo = (ArchivesManagerVo)evaluationMap.get(data.getPositionId() + data.getSubjectId() + data.getYear());
                data.setActualCount(archivesManagerVo.getActualCount());
                data.setNoPassCount(archivesManagerVo.getNoPassCount());
                data.setPassCount(archivesManagerVo.getPassCount());
            }
            if (0L == data.getActualCount()) {
                data.setReferRate("0%");
            } else {
                data.setReferRate(new BigDecimal(data.getActualCount()).divide(new BigDecimal(data.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
            if (0L == data.getPassCount()) {
                data.setPassRate("0%");
            } else {
                data.setPassRate(new BigDecimal(data.getPassCount()).divide(new BigDecimal(data.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%");
            }
        });
        return new PageList(result);
    }

    @Override
    public void subjectArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        PageList<ArchivesManagerVo> pageList = this.subjectArchives(queryFilter);
        JSONObject dataMap = new JSONObject();
        dataMap.put("list", (Object)pageList.getRows());
        if (CollectionUtils.isEmpty((Collection)pageList.getRows())) {
            dataMap.put("year", (Object)LocalDate.now().getYear());
        } else {
            dataMap.put("year", (Object)((ArchivesManagerVo)pageList.getRows().get(0)).getYear());
        }
        String fileId = UniqueIdUtil.getSuid();
        String fileOnlyName = "\u8bfe\u76ee\u6863\u6848.doc";
        String ftlPath = AppFileUtil.createFilePath((String)("ftl" + File.separator + fileId), (String)fileOnlyName);
        WordUtil.createWord((HttpServletResponse)response, (Map)dataMap, (String)"\u8bfe\u76ee\u6863\u6848.ftl", (String)ftlPath, (String)fileOnlyName);
        try {
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (File)new File(ftlPath), (String)fileOnlyName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void orgArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        PageList<ArchivesManagerVo> pageList = this.orgArchives(queryFilter);
        pageList.getRows().forEach(vo -> {
            if (StringUtils.isNotEmpty((CharSequence)vo.getLevel())) {
                vo.setLevel(ScoreLevelEnum.getDesc((Integer)Integer.parseInt(vo.getLevel())));
            }
        });
        JSONObject dataMap = new JSONObject();
        dataMap.put("list", (Object)pageList.getRows());
        if (CollectionUtils.isEmpty((Collection)pageList.getRows())) {
            dataMap.put("year", (Object)LocalDate.now().getYear());
        } else {
            dataMap.put("year", (Object)((ArchivesManagerVo)pageList.getRows().get(0)).getYear());
        }
        String fileId = UniqueIdUtil.getSuid();
        String fileOnlyName = "\u5355\u4f4d\u6863\u6848.doc";
        String ftlPath = AppFileUtil.createFilePath((String)("ftl" + File.separator + fileId), (String)fileOnlyName);
        WordUtil.createWord((HttpServletResponse)response, (Map)dataMap, (String)"\u5355\u4f4d\u6863\u6848.ftl", (String)ftlPath, (String)fileOnlyName);
        try {
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (File)new File(ftlPath), (String)fileOnlyName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void positionArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        PageList<ArchivesManagerVo> pageList = this.positionArchives(queryFilter);
        JSONObject dataMap = new JSONObject();
        dataMap.put("list", (Object)pageList.getRows());
        if (CollectionUtils.isEmpty((Collection)pageList.getRows())) {
            dataMap.put("year", (Object)LocalDate.now().getYear());
        } else {
            dataMap.put("year", (Object)((ArchivesManagerVo)pageList.getRows().get(0)).getYear());
        }
        String fileId = UniqueIdUtil.getSuid();
        String fileOnlyName = "\u5c97\u4f4d\u6863\u6848.doc";
        String ftlPath = AppFileUtil.createFilePath((String)("ftl" + File.separator + fileId), (String)fileOnlyName);
        WordUtil.createWord((HttpServletResponse)response, (Map)dataMap, (String)"\u5c97\u4f4d\u6863\u6848.ftl", (String)ftlPath, (String)fileOnlyName);
        try {
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (File)new File(ftlPath), (String)fileOnlyName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageList<UserExamVo> userQualityAnalyse(QueryFilter<ExamUserEvaluation> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<UserExamVo> result = ((ExamUserEvaluationDao)this.baseMapper).userQualityAnalyse((IPage<ExamUserEvaluation>)this.convert2IPage(pageBean), (Wrapper<ExamUserEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(exam -> {
            String subjectNames = this.userEvaluationDetailManager.getSubjectNames(exam.getPositionId(), exam.getYear(), exam.getUserId());
            if (!StringUtils.isNotEmpty((CharSequence)subjectNames)) {
                return;
            }
            String[] split = subjectNames.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    exam.setSubjectName1(split[i]);
                }
                if (i == 1) {
                    exam.setSubjectName2(split[i]);
                }
                if (i == 2) {
                    exam.setSubjectName3(split[i]);
                }
                if (i != 3) continue;
                exam.setSubjectName4(split[i]);
            }
        });
        return new PageList(result);
    }

    @Override
    public boolean setUserWorkEvaluation(ExamUserEvaluation t) {
        ExamUserEvaluation userEvaluation;
        if (t != null && StringUtils.isNotEmpty((CharSequence)t.getId()) && (userEvaluation = (ExamUserEvaluation)((Object)((ExamUserEvaluationDao)this.baseMapper).selectById((Serializable)((Object)t.getId())))) != null) {
            userEvaluation.setVocationalEducationScore(t.getVocationalEducationScore());
            Integer vocationalEducationScore = t.getVocationalEducationScore();
            if (vocationalEducationScore >= 90) {
                userEvaluation.setVocationalEducationEvaluation(ScoreLevelEnum.GOOD.getDesc());
            } else if (vocationalEducationScore >= 70 && vocationalEducationScore < 90) {
                userEvaluation.setVocationalEducationEvaluation(ScoreLevelEnum.LH.getDesc());
            } else if (vocationalEducationScore >= 60 && vocationalEducationScore < 70) {
                userEvaluation.setVocationalEducationEvaluation(ScoreLevelEnum.JG.getDesc());
            } else {
                userEvaluation.setVocationalEducationEvaluation(ScoreLevelEnum.BJG.getDesc());
            }
            userEvaluation.setVocationalEducationEvaluation(t.getVocationalEducationEvaluation());
            userEvaluation.setOverallEvaluationDescription(t.getOverallEvaluationDescription());
        }
        return false;
    }
}

