/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.constants.CodePrefix;
import com.artfess.base.enums.PaperWayTypeEnum;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.enums.QuestionTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.examine.dao.ExamImitateRecordDao;
import com.artfess.examine.dao.ExamPaperBaseDao;
import com.artfess.examine.dao.ExamQuestionsOptionDao;
import com.artfess.examine.manager.ExamImitateRecordDetailManager;
import com.artfess.examine.manager.ExamImitateRecordManager;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.manager.ExamPaperSettingManager;
import com.artfess.examine.model.ExamImitateRecord;
import com.artfess.examine.model.ExamImitateRecordDetail;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamPaperSetting;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamQuestionsOption;
import com.artfess.examine.vo.ExamReqVo;
import com.artfess.examine.vo.MyExamInfoVo;
import com.artfess.examine.vo.QuestionOptionReqVo;
import com.artfess.examine.vo.QuestionsInfoVo;
import com.artfess.examine.vo.SubmitAnswerReqVo;
import com.artfess.redis.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamImitateRecordManagerImpl
extends BaseManagerImpl<ExamImitateRecordDao, ExamImitateRecord>
implements ExamImitateRecordManager {
    private static final Logger log = LoggerFactory.getLogger(ExamImitateRecordManagerImpl.class);
    @Autowired
    private ExamPaperBaseManager paperBaseManager;
    @Autowired
    private ExamImitateRecordDetailManager imitateRecordDetailManager;
    @Autowired
    private ExamPaperSettingManager paperSettingManager;
    @Resource
    private ExamQuestionsOptionDao questionsOptionDao;
    @Resource
    private ExamPaperBaseDao paperBaseDao;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void startPaper(String id) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createImitate(ExamPaperBase examPaperBase) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_base_id_", (Object)examPaperBase.getId());
        ((ExamImitateRecordDao)this.baseMapper).delete((Wrapper)queryWrapper);
        ExamImitateRecord imitateRecord = new ExamImitateRecord();
        imitateRecord.setPaperBaseId(examPaperBase.getId());
        imitateRecord.setUserId(AuthenticationUtil.getCurrentUserId());
        imitateRecord.setUserName(AuthenticationUtil.getCurrentUsername());
        imitateRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
        ((ExamImitateRecordDao)this.baseMapper).insert((Object)imitateRecord);
        this.processUserRecordDetail(imitateRecord, examPaperBase);
    }

    @Override
    public MyExamInfoVo getUserRecord(String id) {
        ExamImitateRecord imitateRecord = (ExamImitateRecord)((Object)((ExamImitateRecordDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)imitateRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ExamReqVo reqVo = new ExamReqVo();
        reqVo.setRecordId(id);
        List<QuestionsInfoVo> questionList = ((ExamImitateRecordDao)this.baseMapper).getQuestionList(reqVo);
        if (CollectionUtils.isEmpty(questionList)) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u672a\u627e\u5230\u5bf9\u5e94\u9898\u76ee\u4fe1\u606f");
        }
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            if (StringUtils.isEmpty((Object)question.getResult())) {
                question.setActualScore(BigDecimal.ZERO);
            }
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        MyExamInfoVo myExamInfoVo = new MyExamInfoVo();
        BeanUtils.copyProperties((Object)((Object)imitateRecord), (Object)myExamInfoVo);
        reqVo.setRecordId(imitateRecord.getId());
        myExamInfoVo.setQuestionsInfoVos(questionList);
        myExamInfoVo.setRecordId(imitateRecord.getId());
        return myExamInfoVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MyExamInfoVo startExam(ExamReqVo reqVo) {
        Assert.hasText((String)reqVo.getPaperId(), (String)"\u8003\u8bd5\u8bd5\u5377id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id_", (Object)reqVo.getUserId());
        queryWrapper.eq((Object)"paper_base_id_", (Object)reqVo.getPaperId());
        ExamImitateRecord imitateRecord = (ExamImitateRecord)((Object)((ExamImitateRecordDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)imitateRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"paper_id_", (Object)imitateRecord.getPaperBaseId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)query));
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseDao.selectById((Serializable)((Object)imitateRecord.getPaperBaseId())));
        if (QuestionStateEnum.haveTest.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u60a8\u5df2\u4ea4\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.finish.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u5df2\u9605\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.zuobi.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u8003\u8bd5\u4e2d\u6709\u4f5c\u5f0a\u884c\u4e3a\uff0c\u5df2\u88ab\u5f3a\u5236\u4ea4\u5377");
        }
        MyExamInfoVo myExamInfoVo = new MyExamInfoVo();
        BeanUtils.copyProperties((Object)((Object)imitateRecord), (Object)myExamInfoVo);
        reqVo.setRecordId(imitateRecord.getId());
        myExamInfoVo.setTotalNumber(examPaperBase.getTotalNumber());
        myExamInfoVo.setTotalScore(examPaperBase.getTotalScore());
        BigDecimal totalTime = paperSetting.getTimeLength().multiply(new BigDecimal(60)).multiply(new BigDecimal(1000));
        imitateRecord.setStatus(QuestionStateEnum.inTest.getType());
        imitateRecord.setStartTime(LocalDateTime.now());
        myExamInfoVo.setTimeLength(totalTime);
        this.createUserTask(reqVo, paperSetting.getTimeLength());
        ((ExamImitateRecordDao)this.baseMapper).updateById((Object)imitateRecord);
        List<QuestionsInfoVo> questionList = ((ExamImitateRecordDao)this.baseMapper).getQuestionList(reqVo);
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            question.setRightOption(null);
            question.setResult(null);
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        myExamInfoVo.setQuestionsInfoVos(questionList);
        myExamInfoVo.setRecordId(imitateRecord.getId());
        return myExamInfoVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitAnswer(SubmitAnswerReqVo reqVo) {
        ExamImitateRecord imitateRecord = (ExamImitateRecord)((Object)((ExamImitateRecordDao)this.baseMapper).selectById((Serializable)((Object)reqVo.getRecordId())));
        Assert.notNull((Object)((Object)imitateRecord), (String)"\u6a21\u62df\u8003\u8bd5\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)imitateRecord.getPaperBaseId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)paperSetting), (String)"\u8003\u8bd5\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (QuestionStateEnum.haveTest.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u60a8\u5df2\u4ea4\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.finish.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u5df2\u9605\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.zuobi.getType().equals(imitateRecord.getStatus())) {
            throw new RuntimeException("\u8003\u8bd5\u4e2d\u6709\u4f5c\u5f0a\u884c\u4e3a\uff0c\u5df2\u88ab\u5f3a\u5236\u4ea4\u5377");
        }
        List<QuestionOptionReqVo> options = reqVo.getQuestionOptionList();
        HashMap userOptionNumber = Maps.newHashMap();
        options.forEach(option -> {
            if (userOptionNumber.containsKey(option.getQuestionId())) {
                userOptionNumber.put(option.getQuestionId(), (String)userOptionNumber.get(option.getQuestionId()) + "," + option.getResult());
            } else {
                userOptionNumber.put(option.getQuestionId(), option.getResult());
            }
        });
        if (reqVo.getStatus() == 1) {
            imitateRecord.setStatus(QuestionStateEnum.inTest.getType());
        }
        if (null != reqVo.getStatus() && reqVo.getStatus() == 1) {
            imitateRecord.setStatus(QuestionStateEnum.inTest.getType());
            long time = System.currentTimeMillis() - imitateRecord.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            String answerTime = formatter.format(time);
            imitateRecord.setAnswerTime(answerTime);
            imitateRecord.setEndTime(LocalDateTime.now());
        }
        this.calculateScore(userOptionNumber, imitateRecord);
    }

    @Override
    public PageList<ExamImitateRecord> trainingPaperQuery(QueryFilter<ExamImitateRecord> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamImitateRecord> result = ((ExamImitateRecordDao)this.baseMapper).trainingPaperQuery((IPage<ExamImitateRecord>)this.convert2IPage(pageBean), (Wrapper<ExamImitateRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public List<QuestionsInfoVo> errorQuestionsList(String id) {
        List<QuestionsInfoVo> questionList = ((ExamImitateRecordDao)this.baseMapper).errorQuestionsList(id);
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        questionList.sort((o1, o2) -> o1.getType().compareTo(o2.getType()));
        return questionList;
    }

    private void calculateScore(Map<String, String> userOptionNumber, ExamImitateRecord record) {
        log.info("\u95ee\u9898\u9009\u9879\uff1a{}", userOptionNumber);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"record_id_", (Object)record.getId());
        List list = this.imitateRecordDetailManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        Integer totalScore = 0;
        for (ExamImitateRecordDetail question : list) {
            String result = userOptionNumber.get(question.getQuestionId());
            question.setResult(result);
            if (!userOptionNumber.containsKey(question.getQuestionId())) continue;
            if (QuestionTypeEnum.radio.getType().equals(question.getQuestionType()) || QuestionTypeEnum.multi.getType().equals(question.getQuestionType()) || QuestionTypeEnum.judge.getType().equals(question.getQuestionType())) {
                if (result.equals(question.getRightKey())) {
                    question.setActualScore(question.getScore());
                    question.setIsRight("1");
                } else {
                    question.setActualScore(BigDecimal.ZERO);
                    question.setIsRight("0");
                }
                totalScore = totalScore + question.getActualScore().intValue();
            }
            this.imitateRecordDetailManager.updateById((Object)question);
        }
        log.info("\u95ee\u9898\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)list));
        record.setTotalScore(new BigDecimal(totalScore));
        ((ExamImitateRecordDao)this.baseMapper).updateById((Object)record);
    }

    private void processUserRecordDetail(ExamImitateRecord imitateRecord, ExamPaperBase examPaperBase) {
        if (PaperWayTypeEnum.sjcj.getType().equals(examPaperBase.getWayType())) {
            List<ExamQuestionsInfo> examQuestionsInfos = this.paperBaseManager.processQuestionList(examPaperBase);
            this.createUserRecordDetail(imitateRecord, examQuestionsInfos, examPaperBase);
        } else {
            List<ExamQuestionsInfo> examQuestionsInfos = this.paperBaseManager.processQuestionList(examPaperBase);
            this.createUserRecordDetail(imitateRecord, examQuestionsInfos, examPaperBase);
        }
    }

    private void createUserRecordDetail(ExamImitateRecord record, List<ExamQuestionsInfo> examQuestionsInfos, ExamPaperBase examPaperBase) {
        ArrayList details = Lists.newArrayList();
        examQuestionsInfos.forEach(question -> {
            ExamImitateRecordDetail userRecordDetail = new ExamImitateRecordDetail();
            userRecordDetail.setRecordId(record.getId());
            userRecordDetail.setQuestionId(question.getId());
            userRecordDetail.setQuestionType(question.getType());
            userRecordDetail.setRightKey(question.getRightOption());
            userRecordDetail.setScore(question.getScore());
            details.add(userRecordDetail);
        });
        if (!CollectionUtils.isEmpty((Collection)details)) {
            this.imitateRecordDetailManager.saveBatch(details);
        }
    }

    private void createUserTask(ExamReqVo reqVo, BigDecimal timeLength) {
        String key = CodePrefix.PAPER_TASK_KEY.getKey() + ":" + reqVo.getRecordId();
        Long time = timeLength.longValue() * 60L;
        this.redisUtil.set(key, JSON.toJSON((Object)reqVo), time.longValue());
    }

    private void getBalanceAwswerTime(ExamReqVo reqVo) {
        String key = CodePrefix.PAPER_TASK_KEY.getKey() + ":" + reqVo.getRecordId();
        Object taskInfo = this.redisUtil.get(key);
        Assert.notNull((Object)taskInfo, (String)"\u8003\u8bd5\u5df2\u7ed3\u675f");
    }
}

