import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addRecord(data, cb) {
        req.post(portal + `/exam/imitate/record/save`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询
    getQuery(data, cb) {
        req.post(portal + `/exam/paper/base/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改
    editQuery(data, cb) {
        req.put(portal + `/exam/imitate/record/update`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询
    detailId(id, cb) {
        req.get(portal + `/exam/imitate/record/findById/` + id).then(rep => {
            cb(rep.data)
        })
    },
	//开始考试
	startExam(data, cb) {
	    req.post(portal + `/exam/imitate/record/startExam`, data).then(res => {
	        cb(res.data)
	    })
	},
	//提交试卷
	submitAnswer(data, cb) {
	    req.post(portal + `/exam/imitate/record/submitAnswer`, data).then(res => {
	        cb(res.data)
	    })
	},
}