import req from '@/request'

const portal = window.context.portal

// 获取目录
export function getTree(type) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/teachingResources/type/getTree`, {type})
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

// 目录详情
export function treeDetails(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/teachingResources/type/${id}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录新增
export function treeAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/teachingResources/type/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录修改
export function treeEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/teachingResources/type/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录删除
export function treeDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/teachingResources/type/?ids=${ids}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}
