import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addAssess(data, cb) {
        req.post(portal + `/exam/year/assessmentSub/`, data).then(res => {
            cb(res.data)
        })
    },
	// 修改
	editAssess(data, cb) {
	    req.put(portal + `/exam/year/assessmentSub/`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 查询
	queryAssess(data, cb) {
	    req.post(portal + `/exam/year/assessmentSub/findByPage`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 排序
	updateAssess(data, cb) {
	    req.post(portal + `/exam/year/assessmentSub/updateSequence`, data).then(res => {
	        cb(res.data)
	    })
	},
	//id查询实体
	detailAssess(id,cb){
		req.get(portal + `/exam/year/assessmentSub/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//岗位树
	getPositionPage(data, cb) {
	    req.post(portal + `/api/org/v1/orgs/getPositionTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//课目列表
	getSubjects(data, cb) {
		req.post(portal + `/exam/subject/info/query`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
	    req.post(portal + `/exam/user/evaluation/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.post(portal + `/exam/user/evaluation/export`, data, 'blob').then(res => {
		    cb(res.data)
		})
	},
	remove(data, cb){
		req.remove(portal + `/exam/year/assessmentSub/`+ data, 'blob').then(res => {
		    cb(res.data)
		})
	},
	// deleteOneEqeSys(ids, cb) {
	//     return new Promise((resolve, reject) => {
	//         req.remove(portal + '/exam/materialType/type/' + ids).then(res => {
	//             resolve(res);
	//         }, error => {
	//             reject(error);
	//         })
	//     })
	// },
}