import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addEvaluation(data, cb) {
        req.post(portal + `/exam/user/evaluation/`, data).then(res => {
            cb(res.data)
        })
    },
	// 修改
	editEvaluation(data, cb) {
	    req.put(portal + `/exam/user/evaluation/`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 查询
	queryEvaluation(data, cb) {
	    req.post(portal + `/exam/user/evaluation/query`, data).then(res => {
	        cb(res.data)
	    })
	},
	// 排序
	updateEvaluation(data, cb) {
	    req.post(portal + `/exam/user/evaluation/updateSequence`, data).then(res => {
	        cb(res.data)
	    })
	},
	//id查询实体
	detailEvaluation(id,cb){
		req.get(portal + `/exam/user/evaluation/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//岗位树
	getPositionPage(data, cb) {
	    req.post(portal + `/api/org/v1/orgs/getPositionTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//课目列表
	getSubjects(data, cb) {
		req.post(portal + `/exam/subject/info/query`, data).then(res => {
			cb(res.data)
		})
	},
	//详情
	detailPage(data, cb){
		req.post(portal + `/exam/user/evaluation/detailPage`, data).then(res => {
			cb(res.data)
		})
	},
	//获取评定列表
	evaluationDetail(id,cb){
		req.get(portal + `/exam/user/evaluation/evaluationDetail/` + id).then(rep => {
		    cb(rep.data)
		})
	},
	//设置年度最终成绩
	settingYear(data, cb) {
		req.post(portal + `/exam/user/evaluation/settingYear`, data).then(res => {
			cb(res.data)
		})
	},
	//添加课目
	addSubject(data, cb) {
		req.post(portal + `/exam/user/evaluation/addSubject`, data).then(res => {
			cb(res.data)
		})
	},
	//删除课目
	delSubject(data, cb) {
		req.post(portal + `/exam/user/evaluation/delSubject`, data).then(res => {
			cb(res.data)
		})
	},
	//专业id查询课目
	findByMajorIds(data, cb) {
	    req.post(portal + `/exam/subject/info/findByPage`, data).then(res => {
	        cb(res.data)
	    })
	},
	//获取专业装备下拉树
	majorQuery(data, cb) {
	    req.post(portal + `/exam/equipment/sys/getTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//获取当年该岗位要考核的课目
	getSubjectInfo(data,cb){
		req.post(portal + `/exam/user/evaluation/getSubjectInfo`, data).then(res => {
		    cb(res.data)
		})
	},
	//获取当前年度该课目下所有年度考核所有试卷
	getPositionPaper(data,cb){
		req.post(portal + `/exam/user/evaluation/getPositionPaper`, data).then(res => {
		    cb(res.data)
		})
	},
	//批量设置成绩
	batchSettingYear(data,cb){
		req.post(portal + `/exam/user/evaluation/batchSettingYear`, data).then(res => {
		    cb(res.data)
		})
	},
	importExcel(data, cb) {
	    req.post(portal + `/exam/user/evaluation/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.get(portal + `/exam/user/evaluation/export?positionId=`+data).then(res => {
		    cb(res.data)
		})
	},
}